/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.ThumbnailFormat;
import com.dropbox.core.v2.files.ThumbnailMode;
import com.dropbox.core.v2.files.ThumbnailSize;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public class ThumbnailArg {
    protected final String path;
    protected final ThumbnailFormat format;
    protected final ThumbnailSize size;
    protected final ThumbnailMode mode;

    public ThumbnailArg(String path, ThumbnailFormat format, ThumbnailSize size, ThumbnailMode mode) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("(/(.|[\\r\\n])*|id:.*)|(rev:[0-9a-f]{9,})|(ns:[0-9]+(/.*)?)", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        if (format == null) {
            throw new IllegalArgumentException("Required value for 'format' is null");
        }
        this.format = format;
        if (size == null) {
            throw new IllegalArgumentException("Required value for 'size' is null");
        }
        this.size = size;
        if (mode == null) {
            throw new IllegalArgumentException("Required value for 'mode' is null");
        }
        this.mode = mode;
    }

    public ThumbnailArg(String path) {
        this(path, ThumbnailFormat.JPEG, ThumbnailSize.W64H64, ThumbnailMode.STRICT);
    }

    public String getPath() {
        return this.path;
    }

    public ThumbnailFormat getFormat() {
        return this.format;
    }

    public ThumbnailSize getSize() {
        return this.size;
    }

    public ThumbnailMode getMode() {
        return this.mode;
    }

    public static Builder newBuilder(String path) {
        return new Builder(path);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.format, this.size, this.mode});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ThumbnailArg other = (ThumbnailArg)obj;
            return !(this.path != other.path && !this.path.equals(other.path) || this.format != other.format && !this.format.equals((Object)other.format) || this.size != other.size && !this.size.equals((Object)other.size) || this.mode != other.mode && !this.mode.equals((Object)other.mode));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ThumbnailArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ThumbnailArg value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("path");
            StoneSerializers.string().serialize(value.path, g2);
            g2.writeFieldName("format");
            ThumbnailFormat.Serializer.INSTANCE.serialize(value.format, g2);
            g2.writeFieldName("size");
            ThumbnailSize.Serializer.INSTANCE.serialize(value.size, g2);
            g2.writeFieldName("mode");
            ThumbnailMode.Serializer.INSTANCE.serialize(value.mode, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public ThumbnailArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            ThumbnailMode f_mode;
            ThumbnailSize f_size;
            ThumbnailFormat f_format;
            String f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_format = ThumbnailFormat.JPEG;
                f_size = ThumbnailSize.W64H64;
                f_mode = ThumbnailMode.STRICT;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("format".equals(field)) {
                        f_format = ThumbnailFormat.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("size".equals(field)) {
                        f_size = ThumbnailSize.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("mode".equals(field)) {
                        f_mode = ThumbnailMode.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ThumbnailArg value = new ThumbnailArg(f_path, f_format, f_size, f_mode);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String path;
        protected ThumbnailFormat format;
        protected ThumbnailSize size;
        protected ThumbnailMode mode;

        protected Builder(String path) {
            if (path == null) {
                throw new IllegalArgumentException("Required value for 'path' is null");
            }
            if (!Pattern.matches("(/(.|[\\r\\n])*|id:.*)|(rev:[0-9a-f]{9,})|(ns:[0-9]+(/.*)?)", path)) {
                throw new IllegalArgumentException("String 'path' does not match pattern");
            }
            this.path = path;
            this.format = ThumbnailFormat.JPEG;
            this.size = ThumbnailSize.W64H64;
            this.mode = ThumbnailMode.STRICT;
        }

        public Builder withFormat(ThumbnailFormat format) {
            this.format = format != null ? format : ThumbnailFormat.JPEG;
            return this;
        }

        public Builder withSize(ThumbnailSize size) {
            this.size = size != null ? size : ThumbnailSize.W64H64;
            return this;
        }

        public Builder withMode(ThumbnailMode mode) {
            this.mode = mode != null ? mode : ThumbnailMode.STRICT;
            return this;
        }

        public ThumbnailArg build() {
            return new ThumbnailArg(this.path, this.format, this.size, this.mode);
        }
    }
}

