/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.HighlightSpan;
import com.dropbox.core.v2.files.MetadataV2;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class SearchMatchV2 {
    protected final MetadataV2 metadata;
    protected final List<HighlightSpan> highlightSpans;

    public SearchMatchV2(MetadataV2 metadata, List<HighlightSpan> highlightSpans) {
        if (metadata == null) {
            throw new IllegalArgumentException("Required value for 'metadata' is null");
        }
        this.metadata = metadata;
        if (highlightSpans != null) {
            for (HighlightSpan x : highlightSpans) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'highlightSpans' is null");
            }
        }
        this.highlightSpans = highlightSpans;
    }

    public SearchMatchV2(MetadataV2 metadata) {
        this(metadata, null);
    }

    public MetadataV2 getMetadata() {
        return this.metadata;
    }

    public List<HighlightSpan> getHighlightSpans() {
        return this.highlightSpans;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.metadata, this.highlightSpans});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SearchMatchV2 other = (SearchMatchV2)obj;
            return (this.metadata == other.metadata || this.metadata.equals(other.metadata)) && (this.highlightSpans == other.highlightSpans || this.highlightSpans != null && this.highlightSpans.equals(other.highlightSpans));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SearchMatchV2> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SearchMatchV2 value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("metadata");
            MetadataV2.Serializer.INSTANCE.serialize(value.metadata, g2);
            if (value.highlightSpans != null) {
                g2.writeFieldName("highlight_spans");
                StoneSerializers.nullable(StoneSerializers.list(HighlightSpan.Serializer.INSTANCE)).serialize(value.highlightSpans, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public SearchMatchV2 deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<HighlightSpan> f_highlightSpans;
            MetadataV2 f_metadata;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_metadata = null;
                f_highlightSpans = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("metadata".equals(field)) {
                        f_metadata = MetadataV2.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("highlight_spans".equals(field)) {
                        f_highlightSpans = StoneSerializers.nullable(StoneSerializers.list(HighlightSpan.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_metadata == null) {
                    throw new JsonParseException(p, "Required field \"metadata\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SearchMatchV2 value = new SearchMatchV2(f_metadata, f_highlightSpans);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

