/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.users;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class GetAccountBatchError {
    public static final GetAccountBatchError OTHER = new GetAccountBatchError().withTag(Tag.OTHER);
    private Tag _tag;
    private String noAccountValue;

    private GetAccountBatchError() {
    }

    private GetAccountBatchError withTag(Tag _tag) {
        GetAccountBatchError result = new GetAccountBatchError();
        result._tag = _tag;
        return result;
    }

    private GetAccountBatchError withTagAndNoAccount(Tag _tag, String noAccountValue) {
        GetAccountBatchError result = new GetAccountBatchError();
        result._tag = _tag;
        result.noAccountValue = noAccountValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isNoAccount() {
        return this._tag == Tag.NO_ACCOUNT;
    }

    public static GetAccountBatchError noAccount(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() < 40) {
            throw new IllegalArgumentException("String is shorter than 40");
        }
        if (value.length() > 40) {
            throw new IllegalArgumentException("String is longer than 40");
        }
        return new GetAccountBatchError().withTagAndNoAccount(Tag.NO_ACCOUNT, value);
    }

    public String getNoAccountValue() {
        if (this._tag != Tag.NO_ACCOUNT) {
            throw new IllegalStateException("Invalid tag: required Tag.NO_ACCOUNT, but was Tag." + this._tag.name());
        }
        return this.noAccountValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.noAccountValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof GetAccountBatchError) {
            GetAccountBatchError other = (GetAccountBatchError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case NO_ACCOUNT: {
                    return this.noAccountValue == other.noAccountValue || this.noAccountValue.equals(other.noAccountValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends UnionSerializer<GetAccountBatchError> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(GetAccountBatchError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case NO_ACCOUNT: {
                    g2.writeStartObject();
                    this.writeTag("no_account", g2);
                    g2.writeFieldName("no_account");
                    StoneSerializers.string().serialize(value.noAccountValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public GetAccountBatchError deserialize(JsonParser p) throws IOException, JsonParseException {
            GetAccountBatchError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("no_account".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("no_account", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = GetAccountBatchError.noAccount(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        NO_ACCOUNT,
        OTHER;

    }
}

