/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

class ListFileMembersBatchArg {
    protected final List<String> files;
    protected final long limit;

    public ListFileMembersBatchArg(List<String> files, long limit) {
        if (files == null) {
            throw new IllegalArgumentException("Required value for 'files' is null");
        }
        if (files.size() > 100) {
            throw new IllegalArgumentException("List 'files' has more than 100 items");
        }
        for (String x : files) {
            if (x == null) {
                throw new IllegalArgumentException("An item in list 'files' is null");
            }
            if (x.length() < 1) {
                throw new IllegalArgumentException("Stringan item in list 'files' is shorter than 1");
            }
            if (Pattern.matches("((/|id:).*|nspath:[0-9]+:.*)|ns:[0-9]+(/.*)?", x)) continue;
            throw new IllegalArgumentException("Stringan item in list 'files' does not match pattern");
        }
        this.files = files;
        if (limit > 20L) {
            throw new IllegalArgumentException("Number 'limit' is larger than 20L");
        }
        this.limit = limit;
    }

    public ListFileMembersBatchArg(List<String> files) {
        this(files, 10L);
    }

    public List<String> getFiles() {
        return this.files;
    }

    public long getLimit() {
        return this.limit;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.files, this.limit});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListFileMembersBatchArg other = (ListFileMembersBatchArg)obj;
            return (this.files == other.files || this.files.equals(other.files)) && this.limit == other.limit;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ListFileMembersBatchArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ListFileMembersBatchArg value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("files");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.files, g2);
            g2.writeFieldName("limit");
            StoneSerializers.uInt32().serialize((Long)value.limit, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public ListFileMembersBatchArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_limit;
            List<String> f_files;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_files = null;
                f_limit = 10L;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("files".equals(field)) {
                        f_files = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("limit".equals(field)) {
                        f_limit = StoneSerializers.uInt32().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_files == null) {
                    throw new JsonParseException(p, "Required field \"files\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ListFileMembersBatchArg value = new ListFileMembersBatchArg(f_files, f_limit);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

