/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.filerequests;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.filerequests.FileRequestDeadline;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class UpdateFileRequestDeadline {
    public static final UpdateFileRequestDeadline NO_UPDATE = new UpdateFileRequestDeadline().withTag(Tag.NO_UPDATE);
    public static final UpdateFileRequestDeadline OTHER = new UpdateFileRequestDeadline().withTag(Tag.OTHER);
    private Tag _tag;
    private FileRequestDeadline updateValue;

    private UpdateFileRequestDeadline() {
    }

    private UpdateFileRequestDeadline withTag(Tag _tag) {
        UpdateFileRequestDeadline result = new UpdateFileRequestDeadline();
        result._tag = _tag;
        return result;
    }

    private UpdateFileRequestDeadline withTagAndUpdate(Tag _tag, FileRequestDeadline updateValue) {
        UpdateFileRequestDeadline result = new UpdateFileRequestDeadline();
        result._tag = _tag;
        result.updateValue = updateValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isNoUpdate() {
        return this._tag == Tag.NO_UPDATE;
    }

    public boolean isUpdate() {
        return this._tag == Tag.UPDATE;
    }

    public static UpdateFileRequestDeadline update(FileRequestDeadline value) {
        return new UpdateFileRequestDeadline().withTagAndUpdate(Tag.UPDATE, value);
    }

    public static UpdateFileRequestDeadline update() {
        return UpdateFileRequestDeadline.update(null);
    }

    public FileRequestDeadline getUpdateValue() {
        if (this._tag != Tag.UPDATE) {
            throw new IllegalStateException("Invalid tag: required Tag.UPDATE, but was Tag." + this._tag.name());
        }
        return this.updateValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.updateValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof UpdateFileRequestDeadline) {
            UpdateFileRequestDeadline other = (UpdateFileRequestDeadline)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case NO_UPDATE: {
                    return true;
                }
                case UPDATE: {
                    return this.updateValue == other.updateValue || this.updateValue != null && this.updateValue.equals(other.updateValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<UpdateFileRequestDeadline> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UpdateFileRequestDeadline value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case NO_UPDATE: {
                    g2.writeString("no_update");
                    break;
                }
                case UPDATE: {
                    g2.writeStartObject();
                    this.writeTag("update", g2);
                    StoneSerializers.nullableStruct(FileRequestDeadline.Serializer.INSTANCE).serialize(value.updateValue, g2, true);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public UpdateFileRequestDeadline deserialize(JsonParser p) throws IOException, JsonParseException {
            UpdateFileRequestDeadline value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("no_update".equals(tag)) {
                value = NO_UPDATE;
            } else if ("update".equals(tag)) {
                FileRequestDeadline fieldValue = null;
                if (p.getCurrentToken() != JsonToken.END_OBJECT) {
                    fieldValue = StoneSerializers.nullableStruct(FileRequestDeadline.Serializer.INSTANCE).deserialize(p, true);
                }
                value = fieldValue == null ? UpdateFileRequestDeadline.update() : UpdateFileRequestDeadline.update(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        NO_UPDATE,
        UPDATE,
        OTHER;

    }
}

