/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.AdminTier;
import com.dropbox.core.v2.team.TeamMemberProfile;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class TeamMemberInfo {
    protected final TeamMemberProfile profile;
    protected final AdminTier role;

    public TeamMemberInfo(TeamMemberProfile profile, AdminTier role) {
        if (profile == null) {
            throw new IllegalArgumentException("Required value for 'profile' is null");
        }
        this.profile = profile;
        if (role == null) {
            throw new IllegalArgumentException("Required value for 'role' is null");
        }
        this.role = role;
    }

    public TeamMemberProfile getProfile() {
        return this.profile;
    }

    public AdminTier getRole() {
        return this.role;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.profile, this.role});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamMemberInfo other = (TeamMemberInfo)obj;
            return !(this.profile != other.profile && !this.profile.equals(other.profile) || this.role != other.role && !this.role.equals((Object)other.role));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TeamMemberInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamMemberInfo value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("profile");
            TeamMemberProfile.Serializer.INSTANCE.serialize(value.profile, g2);
            g2.writeFieldName("role");
            AdminTier.Serializer.INSTANCE.serialize(value.role, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public TeamMemberInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            AdminTier f_role;
            TeamMemberProfile f_profile;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_profile = null;
                f_role = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("profile".equals(field)) {
                        f_profile = (TeamMemberProfile)TeamMemberProfile.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("role".equals(field)) {
                        f_role = AdminTier.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_profile == null) {
                    throw new JsonParseException(p, "Required field \"profile\" missing.");
                }
                if (f_role == null) {
                    throw new JsonParseException(p, "Required field \"role\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TeamMemberInfo value = new TeamMemberInfo(f_profile, f_role);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

