/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.AccessLevel;
import com.dropbox.core.v2.users.Team;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class SharedFolderMetadataBase {
    protected final AccessLevel accessType;
    protected final boolean isInsideTeamFolder;
    protected final boolean isTeamFolder;
    protected final List<String> ownerDisplayNames;
    protected final Team ownerTeam;
    protected final String parentSharedFolderId;
    protected final String pathLower;
    protected final String parentFolderName;

    public SharedFolderMetadataBase(AccessLevel accessType, boolean isInsideTeamFolder, boolean isTeamFolder, List<String> ownerDisplayNames, Team ownerTeam, String parentSharedFolderId, String pathLower, String parentFolderName) {
        if (accessType == null) {
            throw new IllegalArgumentException("Required value for 'accessType' is null");
        }
        this.accessType = accessType;
        this.isInsideTeamFolder = isInsideTeamFolder;
        this.isTeamFolder = isTeamFolder;
        if (ownerDisplayNames != null) {
            for (String x : ownerDisplayNames) {
                if (x != null) continue;
                throw new IllegalArgumentException("An item in list 'ownerDisplayNames' is null");
            }
        }
        this.ownerDisplayNames = ownerDisplayNames;
        this.ownerTeam = ownerTeam;
        if (parentSharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", parentSharedFolderId)) {
            throw new IllegalArgumentException("String 'parentSharedFolderId' does not match pattern");
        }
        this.parentSharedFolderId = parentSharedFolderId;
        this.pathLower = pathLower;
        this.parentFolderName = parentFolderName;
    }

    public SharedFolderMetadataBase(AccessLevel accessType, boolean isInsideTeamFolder, boolean isTeamFolder) {
        this(accessType, isInsideTeamFolder, isTeamFolder, null, null, null, null, null);
    }

    public AccessLevel getAccessType() {
        return this.accessType;
    }

    public boolean getIsInsideTeamFolder() {
        return this.isInsideTeamFolder;
    }

    public boolean getIsTeamFolder() {
        return this.isTeamFolder;
    }

    public List<String> getOwnerDisplayNames() {
        return this.ownerDisplayNames;
    }

    public Team getOwnerTeam() {
        return this.ownerTeam;
    }

    public String getParentSharedFolderId() {
        return this.parentSharedFolderId;
    }

    public String getPathLower() {
        return this.pathLower;
    }

    public String getParentFolderName() {
        return this.parentFolderName;
    }

    public static Builder newBuilder(AccessLevel accessType, boolean isInsideTeamFolder, boolean isTeamFolder) {
        return new Builder(accessType, isInsideTeamFolder, isTeamFolder);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.accessType, this.isInsideTeamFolder, this.isTeamFolder, this.ownerDisplayNames, this.ownerTeam, this.parentSharedFolderId, this.pathLower, this.parentFolderName});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharedFolderMetadataBase other = (SharedFolderMetadataBase)obj;
            return (this.accessType == other.accessType || this.accessType.equals((Object)other.accessType)) && this.isInsideTeamFolder == other.isInsideTeamFolder && this.isTeamFolder == other.isTeamFolder && (this.ownerDisplayNames == other.ownerDisplayNames || this.ownerDisplayNames != null && this.ownerDisplayNames.equals(other.ownerDisplayNames)) && (this.ownerTeam == other.ownerTeam || this.ownerTeam != null && this.ownerTeam.equals(other.ownerTeam)) && (this.parentSharedFolderId == other.parentSharedFolderId || this.parentSharedFolderId != null && this.parentSharedFolderId.equals(other.parentSharedFolderId)) && (this.pathLower == other.pathLower || this.pathLower != null && this.pathLower.equals(other.pathLower)) && (this.parentFolderName == other.parentFolderName || this.parentFolderName != null && this.parentFolderName.equals(other.parentFolderName));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    private static class Serializer
    extends StructSerializer<SharedFolderMetadataBase> {
        public static final Serializer INSTANCE = new Serializer();

        private Serializer() {
        }

        @Override
        public void serialize(SharedFolderMetadataBase value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("access_type");
            AccessLevel.Serializer.INSTANCE.serialize(value.accessType, g2);
            g2.writeFieldName("is_inside_team_folder");
            StoneSerializers.boolean_().serialize((Boolean)value.isInsideTeamFolder, g2);
            g2.writeFieldName("is_team_folder");
            StoneSerializers.boolean_().serialize((Boolean)value.isTeamFolder, g2);
            if (value.ownerDisplayNames != null) {
                g2.writeFieldName("owner_display_names");
                StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).serialize(value.ownerDisplayNames, g2);
            }
            if (value.ownerTeam != null) {
                g2.writeFieldName("owner_team");
                StoneSerializers.nullableStruct(Team.Serializer.INSTANCE).serialize(value.ownerTeam, g2);
            }
            if (value.parentSharedFolderId != null) {
                g2.writeFieldName("parent_shared_folder_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.parentSharedFolderId, g2);
            }
            if (value.pathLower != null) {
                g2.writeFieldName("path_lower");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.pathLower, g2);
            }
            if (value.parentFolderName != null) {
                g2.writeFieldName("parent_folder_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.parentFolderName, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public SharedFolderMetadataBase deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_parentFolderName;
            String f_pathLower;
            String f_parentSharedFolderId;
            Team f_ownerTeam;
            List<String> f_ownerDisplayNames;
            Boolean f_isTeamFolder;
            Boolean f_isInsideTeamFolder;
            AccessLevel f_accessType;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_accessType = null;
                f_isInsideTeamFolder = null;
                f_isTeamFolder = null;
                f_ownerDisplayNames = null;
                f_ownerTeam = null;
                f_parentSharedFolderId = null;
                f_pathLower = null;
                f_parentFolderName = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("access_type".equals(field)) {
                        f_accessType = AccessLevel.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("is_inside_team_folder".equals(field)) {
                        f_isInsideTeamFolder = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("is_team_folder".equals(field)) {
                        f_isTeamFolder = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("owner_display_names".equals(field)) {
                        f_ownerDisplayNames = StoneSerializers.nullable(StoneSerializers.list(StoneSerializers.string())).deserialize(p);
                        continue;
                    }
                    if ("owner_team".equals(field)) {
                        f_ownerTeam = StoneSerializers.nullableStruct(Team.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("parent_shared_folder_id".equals(field)) {
                        f_parentSharedFolderId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("path_lower".equals(field)) {
                        f_pathLower = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("parent_folder_name".equals(field)) {
                        f_parentFolderName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_accessType == null) {
                    throw new JsonParseException(p, "Required field \"access_type\" missing.");
                }
                if (f_isInsideTeamFolder == null) {
                    throw new JsonParseException(p, "Required field \"is_inside_team_folder\" missing.");
                }
                if (f_isTeamFolder == null) {
                    throw new JsonParseException(p, "Required field \"is_team_folder\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SharedFolderMetadataBase value = new SharedFolderMetadataBase(f_accessType, f_isInsideTeamFolder, f_isTeamFolder, f_ownerDisplayNames, f_ownerTeam, f_parentSharedFolderId, f_pathLower, f_parentFolderName);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final AccessLevel accessType;
        protected final boolean isInsideTeamFolder;
        protected final boolean isTeamFolder;
        protected List<String> ownerDisplayNames;
        protected Team ownerTeam;
        protected String parentSharedFolderId;
        protected String pathLower;
        protected String parentFolderName;

        protected Builder(AccessLevel accessType, boolean isInsideTeamFolder, boolean isTeamFolder) {
            if (accessType == null) {
                throw new IllegalArgumentException("Required value for 'accessType' is null");
            }
            this.accessType = accessType;
            this.isInsideTeamFolder = isInsideTeamFolder;
            this.isTeamFolder = isTeamFolder;
            this.ownerDisplayNames = null;
            this.ownerTeam = null;
            this.parentSharedFolderId = null;
            this.pathLower = null;
            this.parentFolderName = null;
        }

        public Builder withOwnerDisplayNames(List<String> ownerDisplayNames) {
            if (ownerDisplayNames != null) {
                for (String x : ownerDisplayNames) {
                    if (x != null) continue;
                    throw new IllegalArgumentException("An item in list 'ownerDisplayNames' is null");
                }
            }
            this.ownerDisplayNames = ownerDisplayNames;
            return this;
        }

        public Builder withOwnerTeam(Team ownerTeam) {
            this.ownerTeam = ownerTeam;
            return this;
        }

        public Builder withParentSharedFolderId(String parentSharedFolderId) {
            if (parentSharedFolderId != null && !Pattern.matches("[-_0-9a-zA-Z:]+", parentSharedFolderId)) {
                throw new IllegalArgumentException("String 'parentSharedFolderId' does not match pattern");
            }
            this.parentSharedFolderId = parentSharedFolderId;
            return this;
        }

        public Builder withPathLower(String pathLower) {
            this.pathLower = pathLower;
            return this;
        }

        public Builder withParentFolderName(String parentFolderName) {
            this.parentFolderName = parentFolderName;
            return this;
        }

        public SharedFolderMetadataBase build() {
            return new SharedFolderMetadataBase(this.accessType, this.isInsideTeamFolder, this.isTeamFolder, this.ownerDisplayNames, this.ownerTeam, this.parentSharedFolderId, this.pathLower, this.parentFolderName);
        }
    }
}

