/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.filerequests;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.filerequests.FileRequest;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class ListFileRequestsV2Result {
    protected final List<FileRequest> fileRequests;
    protected final String cursor;
    protected final boolean hasMore;

    public ListFileRequestsV2Result(List<FileRequest> fileRequests, String cursor, boolean hasMore) {
        if (fileRequests == null) {
            throw new IllegalArgumentException("Required value for 'fileRequests' is null");
        }
        for (FileRequest x : fileRequests) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'fileRequests' is null");
        }
        this.fileRequests = fileRequests;
        if (cursor == null) {
            throw new IllegalArgumentException("Required value for 'cursor' is null");
        }
        this.cursor = cursor;
        this.hasMore = hasMore;
    }

    public List<FileRequest> getFileRequests() {
        return this.fileRequests;
    }

    public String getCursor() {
        return this.cursor;
    }

    public boolean getHasMore() {
        return this.hasMore;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.fileRequests, this.cursor, this.hasMore});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListFileRequestsV2Result other = (ListFileRequestsV2Result)obj;
            return !(this.fileRequests != other.fileRequests && !this.fileRequests.equals(other.fileRequests) || this.cursor != other.cursor && !this.cursor.equals(other.cursor) || this.hasMore != other.hasMore);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ListFileRequestsV2Result> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ListFileRequestsV2Result value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("file_requests");
            StoneSerializers.list(FileRequest.Serializer.INSTANCE).serialize(value.fileRequests, g2);
            g2.writeFieldName("cursor");
            StoneSerializers.string().serialize(value.cursor, g2);
            g2.writeFieldName("has_more");
            StoneSerializers.boolean_().serialize((Boolean)value.hasMore, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public ListFileRequestsV2Result deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_hasMore;
            String f_cursor;
            List<FileRequest> f_fileRequests;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_fileRequests = null;
                f_cursor = null;
                f_hasMore = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("file_requests".equals(field)) {
                        f_fileRequests = StoneSerializers.list(FileRequest.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("cursor".equals(field)) {
                        f_cursor = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("has_more".equals(field)) {
                        f_hasMore = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_fileRequests == null) {
                    throw new JsonParseException(p, "Required field \"file_requests\" missing.");
                }
                if (f_cursor == null) {
                    throw new JsonParseException(p, "Required field \"cursor\" missing.");
                }
                if (f_hasMore == null) {
                    throw new JsonParseException(p, "Required field \"has_more\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ListFileRequestsV2Result value = new ListFileRequestsV2Result(f_fileRequests, f_cursor, f_hasMore);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

