/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.util.logging;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.status.ErrorStatus;
import club.minnced.discord.webhook.WebhookClient;
import club.minnced.discord.webhook.WebhookClientBuilder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WebhookAppender
extends AppenderBase<ILoggingEvent> {
    private static final Pattern WH_PATTERN = Pattern.compile("(?:https?://)?(?:\\w+\\.)?discordapp\\.com/api(?:/v\\d+)?/webhooks/(\\d+)/([\\w-]+)(?:/(?:\\w+)?)?");
    private Encoder<ILoggingEvent> encoder;
    private String webhookUrl;
    private WebhookClient client;

    @Override
    public void start() {
        int warn = 0;
        if (this.encoder == null) {
            this.addStatus(new ErrorStatus("No encoder specified", this));
            ++warn;
        }
        Matcher matcher = null;
        if (this.webhookUrl == null || this.webhookUrl.isEmpty()) {
            this.addStatus(new ErrorStatus("No Webhook url specified", this));
            ++warn;
        } else {
            matcher = WH_PATTERN.matcher(this.webhookUrl);
            if (!matcher.matches()) {
                this.addStatus(new ErrorStatus("Webhook url was not a valid Webhook url", this));
                ++warn;
            }
        }
        if (warn == 0) {
            this.client = new WebhookClientBuilder(Long.parseUnsignedLong(matcher.group(1)), matcher.group(2)).setDaemon(true).build();
            super.start();
        }
    }

    @Override
    public void stop() {
        if (this.client != null) {
            this.client.close();
        }
        super.stop();
    }

    @Override
    protected void append(ILoggingEvent eventObject) {
        if (!this.isStarted()) {
            return;
        }
        if (eventObject.getLoggerName().equals("club.minnced.discord.webhook.WebhookClient")) {
            return;
        }
        byte[] encode = this.encoder.encode(eventObject);
        String log = new String(encode);
        this.client.send(log.length() > 2000 ? log.substring(0, 1997) + "..." : log);
    }

    public String getWebhookUrl() {
        return this.webhookUrl;
    }

    public void setWebhookUrl(String webhookUrl) {
        this.webhookUrl = webhookUrl;
    }

    public Encoder<ILoggingEvent> getEncoder() {
        return this.encoder;
    }

    public void setEncoder(Encoder<ILoggingEvent> encoder) {
        this.encoder = encoder;
    }
}

