/*
 * Decompiled with CFR 0.152.
 */
package com.kantenkugel.discordbot.jenkinsutil;

import com.kantenkugel.discordbot.jenkinsutil.JenkinsApi;
import com.kantenkugel.discordbot.jenkinsutil.JenkinsChange;
import com.kantenkugel.discordbot.jenkinsutil.JenkinsUser;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class JenkinsBuild {
    public final int buildNum;
    public final Status status;
    public final OffsetDateTime buildTime;
    public final Map<String, Artifact> artifacts;
    public final List<JenkinsChange> changes;
    public final List<JenkinsUser> culprits;
    private final String jenkinsPath;

    private JenkinsBuild(int buildNum, Status status, OffsetDateTime buildTime, List<JenkinsChange> changes, List<JenkinsUser> culprits, String jenkinsPath) {
        this.buildNum = buildNum;
        this.status = status;
        this.buildTime = buildTime;
        this.artifacts = new HashMap<String, Artifact>();
        this.changes = changes;
        this.culprits = culprits;
        this.jenkinsPath = jenkinsPath;
    }

    public String getUrl() {
        return this.jenkinsPath + this.buildNum + "/";
    }

    private void addArtifact(String fileName, String relPath) {
        Artifact artifact = new Artifact(fileName, relPath);
        if (this.artifacts.containsKey(artifact.descriptor)) {
            JenkinsApi.LOG.warn(String.format("Warning: overwriting artifact with same descriptor: %s -> %s", this.artifacts.get((Object)artifact.descriptor).fileName, artifact.fileName));
        }
        this.artifacts.put(artifact.descriptor, artifact);
    }

    static JenkinsBuild fromJson(JSONObject json, JenkinsApi base) {
        int buildNum = json.getInt("id");
        Status status = json.getBoolean("building") ? Status.BUILDING : Status.valueOf(json.getString("result"));
        OffsetDateTime buildTime = OffsetDateTime.ofInstant(Instant.ofEpochMilli(json.getLong("timestamp")), ZoneId.systemDefault());
        JSONArray changeArr = json.getJSONObject("changeSet").getJSONArray("items");
        ArrayList<JenkinsChange> changes = new ArrayList<JenkinsChange>(changeArr.length());
        for (int i = 0; i < changeArr.length(); ++i) {
            changes.add(JenkinsChange.fromJson(changeArr.getJSONObject(i)));
        }
        JSONArray culpritArr = json.getJSONArray("culprits");
        ArrayList<JenkinsUser> culprits = new ArrayList<JenkinsUser>(culpritArr.length());
        for (int i = 0; i < culpritArr.length(); ++i) {
            JSONObject culprit = culpritArr.getJSONObject(i);
            culprits.add(new JenkinsUser(culprit.getString("fullName"), culprit.getString("id"), culprit.isNull("description") ? null : culprit.getString("description")));
        }
        JSONArray artifactArr = json.getJSONArray("artifacts");
        JenkinsBuild build = new JenkinsBuild(buildNum, status, buildTime, changes, culprits, base.jenkinsBase);
        for (int i = 0; i < artifactArr.length(); ++i) {
            JSONObject artifactObj = artifactArr.getJSONObject(i);
            build.addArtifact(artifactObj.getString("fileName"), artifactObj.getString("relativePath"));
        }
        return build;
    }

    public static enum Status {
        BUILDING,
        SUCCESS,
        FAILURE;

    }

    public class Artifact {
        public final String fileName;
        public final List<String> fileNameParts;
        public final String fileEnding;
        public final String descriptor;
        private final String relPath;

        private Artifact(String fileName, String relPath) {
            this.fileName = fileName;
            this.relPath = relPath;
            int fileTypeSeparatorIndex = fileName.lastIndexOf(46);
            this.fileEnding = fileName.substring(fileTypeSeparatorIndex + 1);
            this.fileNameParts = Collections.unmodifiableList(Arrays.asList(fileName.substring(0, fileTypeSeparatorIndex).split("-")));
            if (this.fileNameParts.size() < 3) {
                this.descriptor = this.fileNameParts.get(0);
            } else {
                LinkedList<String> strings = new LinkedList<String>(this.fileNameParts);
                strings.remove(1);
                this.descriptor = String.join((CharSequence)"-", strings);
            }
        }

        public String getLink() {
            return JenkinsBuild.this.getUrl() + "artifact/" + this.relPath;
        }
    }
}

