/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.teamlog.DesktopDeviceSessionLogInfo;
import com.dropbox.core.v2.teamlog.LegacyDeviceSessionLogInfo;
import com.dropbox.core.v2.teamlog.MobileDeviceSessionLogInfo;
import com.dropbox.core.v2.teamlog.WebDeviceSessionLogInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class LinkedDeviceLogInfo {
    public static final LinkedDeviceLogInfo OTHER = new LinkedDeviceLogInfo().withTag(Tag.OTHER);
    private Tag _tag;
    private MobileDeviceSessionLogInfo mobileDeviceSessionValue;
    private DesktopDeviceSessionLogInfo desktopDeviceSessionValue;
    private WebDeviceSessionLogInfo webDeviceSessionValue;
    private LegacyDeviceSessionLogInfo legacyDeviceSessionValue;

    private LinkedDeviceLogInfo() {
    }

    private LinkedDeviceLogInfo withTag(Tag _tag) {
        LinkedDeviceLogInfo result = new LinkedDeviceLogInfo();
        result._tag = _tag;
        return result;
    }

    private LinkedDeviceLogInfo withTagAndMobileDeviceSession(Tag _tag, MobileDeviceSessionLogInfo mobileDeviceSessionValue) {
        LinkedDeviceLogInfo result = new LinkedDeviceLogInfo();
        result._tag = _tag;
        result.mobileDeviceSessionValue = mobileDeviceSessionValue;
        return result;
    }

    private LinkedDeviceLogInfo withTagAndDesktopDeviceSession(Tag _tag, DesktopDeviceSessionLogInfo desktopDeviceSessionValue) {
        LinkedDeviceLogInfo result = new LinkedDeviceLogInfo();
        result._tag = _tag;
        result.desktopDeviceSessionValue = desktopDeviceSessionValue;
        return result;
    }

    private LinkedDeviceLogInfo withTagAndWebDeviceSession(Tag _tag, WebDeviceSessionLogInfo webDeviceSessionValue) {
        LinkedDeviceLogInfo result = new LinkedDeviceLogInfo();
        result._tag = _tag;
        result.webDeviceSessionValue = webDeviceSessionValue;
        return result;
    }

    private LinkedDeviceLogInfo withTagAndLegacyDeviceSession(Tag _tag, LegacyDeviceSessionLogInfo legacyDeviceSessionValue) {
        LinkedDeviceLogInfo result = new LinkedDeviceLogInfo();
        result._tag = _tag;
        result.legacyDeviceSessionValue = legacyDeviceSessionValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isMobileDeviceSession() {
        return this._tag == Tag.MOBILE_DEVICE_SESSION;
    }

    public static LinkedDeviceLogInfo mobileDeviceSession(MobileDeviceSessionLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new LinkedDeviceLogInfo().withTagAndMobileDeviceSession(Tag.MOBILE_DEVICE_SESSION, value);
    }

    public MobileDeviceSessionLogInfo getMobileDeviceSessionValue() {
        if (this._tag != Tag.MOBILE_DEVICE_SESSION) {
            throw new IllegalStateException("Invalid tag: required Tag.MOBILE_DEVICE_SESSION, but was Tag." + this._tag.name());
        }
        return this.mobileDeviceSessionValue;
    }

    public boolean isDesktopDeviceSession() {
        return this._tag == Tag.DESKTOP_DEVICE_SESSION;
    }

    public static LinkedDeviceLogInfo desktopDeviceSession(DesktopDeviceSessionLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new LinkedDeviceLogInfo().withTagAndDesktopDeviceSession(Tag.DESKTOP_DEVICE_SESSION, value);
    }

    public DesktopDeviceSessionLogInfo getDesktopDeviceSessionValue() {
        if (this._tag != Tag.DESKTOP_DEVICE_SESSION) {
            throw new IllegalStateException("Invalid tag: required Tag.DESKTOP_DEVICE_SESSION, but was Tag." + this._tag.name());
        }
        return this.desktopDeviceSessionValue;
    }

    public boolean isWebDeviceSession() {
        return this._tag == Tag.WEB_DEVICE_SESSION;
    }

    public static LinkedDeviceLogInfo webDeviceSession(WebDeviceSessionLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new LinkedDeviceLogInfo().withTagAndWebDeviceSession(Tag.WEB_DEVICE_SESSION, value);
    }

    public WebDeviceSessionLogInfo getWebDeviceSessionValue() {
        if (this._tag != Tag.WEB_DEVICE_SESSION) {
            throw new IllegalStateException("Invalid tag: required Tag.WEB_DEVICE_SESSION, but was Tag." + this._tag.name());
        }
        return this.webDeviceSessionValue;
    }

    public boolean isLegacyDeviceSession() {
        return this._tag == Tag.LEGACY_DEVICE_SESSION;
    }

    public static LinkedDeviceLogInfo legacyDeviceSession(LegacyDeviceSessionLogInfo value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new LinkedDeviceLogInfo().withTagAndLegacyDeviceSession(Tag.LEGACY_DEVICE_SESSION, value);
    }

    public LegacyDeviceSessionLogInfo getLegacyDeviceSessionValue() {
        if (this._tag != Tag.LEGACY_DEVICE_SESSION) {
            throw new IllegalStateException("Invalid tag: required Tag.LEGACY_DEVICE_SESSION, but was Tag." + this._tag.name());
        }
        return this.legacyDeviceSessionValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.mobileDeviceSessionValue, this.desktopDeviceSessionValue, this.webDeviceSessionValue, this.legacyDeviceSessionValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof LinkedDeviceLogInfo) {
            LinkedDeviceLogInfo other = (LinkedDeviceLogInfo)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case MOBILE_DEVICE_SESSION: {
                    return this.mobileDeviceSessionValue == other.mobileDeviceSessionValue || this.mobileDeviceSessionValue.equals(other.mobileDeviceSessionValue);
                }
                case DESKTOP_DEVICE_SESSION: {
                    return this.desktopDeviceSessionValue == other.desktopDeviceSessionValue || this.desktopDeviceSessionValue.equals(other.desktopDeviceSessionValue);
                }
                case WEB_DEVICE_SESSION: {
                    return this.webDeviceSessionValue == other.webDeviceSessionValue || this.webDeviceSessionValue.equals(other.webDeviceSessionValue);
                }
                case LEGACY_DEVICE_SESSION: {
                    return this.legacyDeviceSessionValue == other.legacyDeviceSessionValue || this.legacyDeviceSessionValue.equals(other.legacyDeviceSessionValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<LinkedDeviceLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(LinkedDeviceLogInfo value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case MOBILE_DEVICE_SESSION: {
                    g2.writeStartObject();
                    this.writeTag("mobile_device_session", g2);
                    MobileDeviceSessionLogInfo.Serializer.INSTANCE.serialize(value.mobileDeviceSessionValue, g2, true);
                    g2.writeEndObject();
                    break;
                }
                case DESKTOP_DEVICE_SESSION: {
                    g2.writeStartObject();
                    this.writeTag("desktop_device_session", g2);
                    DesktopDeviceSessionLogInfo.Serializer.INSTANCE.serialize(value.desktopDeviceSessionValue, g2, true);
                    g2.writeEndObject();
                    break;
                }
                case WEB_DEVICE_SESSION: {
                    g2.writeStartObject();
                    this.writeTag("web_device_session", g2);
                    WebDeviceSessionLogInfo.Serializer.INSTANCE.serialize(value.webDeviceSessionValue, g2, true);
                    g2.writeEndObject();
                    break;
                }
                case LEGACY_DEVICE_SESSION: {
                    g2.writeStartObject();
                    this.writeTag("legacy_device_session", g2);
                    LegacyDeviceSessionLogInfo.Serializer.INSTANCE.serialize(value.legacyDeviceSessionValue, g2, true);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public LinkedDeviceLogInfo deserialize(JsonParser p) throws IOException, JsonParseException {
            LinkedDeviceLogInfo value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("mobile_device_session".equals(tag)) {
                MobileDeviceSessionLogInfo fieldValue = null;
                fieldValue = MobileDeviceSessionLogInfo.Serializer.INSTANCE.deserialize(p, true);
                value = LinkedDeviceLogInfo.mobileDeviceSession(fieldValue);
            } else if ("desktop_device_session".equals(tag)) {
                DesktopDeviceSessionLogInfo fieldValue = null;
                fieldValue = DesktopDeviceSessionLogInfo.Serializer.INSTANCE.deserialize(p, true);
                value = LinkedDeviceLogInfo.desktopDeviceSession(fieldValue);
            } else if ("web_device_session".equals(tag)) {
                WebDeviceSessionLogInfo fieldValue = null;
                fieldValue = WebDeviceSessionLogInfo.Serializer.INSTANCE.deserialize(p, true);
                value = LinkedDeviceLogInfo.webDeviceSession(fieldValue);
            } else if ("legacy_device_session".equals(tag)) {
                LegacyDeviceSessionLogInfo fieldValue = null;
                fieldValue = LegacyDeviceSessionLogInfo.Serializer.INSTANCE.deserialize(p, true);
                value = LinkedDeviceLogInfo.legacyDeviceSession(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        MOBILE_DEVICE_SESSION,
        DESKTOP_DEVICE_SESSION,
        WEB_DEVICE_SESSION,
        LEGACY_DEVICE_SESSION,
        OTHER;

    }
}

