/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamlog.FileOrFolderLogInfo;
import com.dropbox.core.v2.teamlog.PathLogInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class FolderLogInfo
extends FileOrFolderLogInfo {
    protected final Long fileCount;

    public FolderLogInfo(PathLogInfo path, String displayName, String fileId, Long fileSize, Long fileCount) {
        super(path, displayName, fileId, fileSize);
        this.fileCount = fileCount;
    }

    public FolderLogInfo(PathLogInfo path) {
        this(path, null, null, null, null);
    }

    @Override
    public PathLogInfo getPath() {
        return this.path;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getFileId() {
        return this.fileId;
    }

    @Override
    public Long getFileSize() {
        return this.fileSize;
    }

    public Long getFileCount() {
        return this.fileCount;
    }

    public static Builder newBuilder(PathLogInfo path) {
        return new Builder(path);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.fileCount});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FolderLogInfo other = (FolderLogInfo)obj;
            return (this.path == other.path || this.path.equals(other.path)) && (this.displayName == other.displayName || this.displayName != null && this.displayName.equals(other.displayName)) && (this.fileId == other.fileId || this.fileId != null && this.fileId.equals(other.fileId)) && (this.fileSize == other.fileSize || this.fileSize != null && this.fileSize.equals(other.fileSize)) && (this.fileCount == other.fileCount || this.fileCount != null && this.fileCount.equals(other.fileCount));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FolderLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FolderLogInfo value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("path");
            PathLogInfo.Serializer.INSTANCE.serialize(value.path, g2);
            if (value.displayName != null) {
                g2.writeFieldName("display_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.displayName, g2);
            }
            if (value.fileId != null) {
                g2.writeFieldName("file_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.fileId, g2);
            }
            if (value.fileSize != null) {
                g2.writeFieldName("file_size");
                StoneSerializers.nullable(StoneSerializers.uInt64()).serialize(value.fileSize, g2);
            }
            if (value.fileCount != null) {
                g2.writeFieldName("file_count");
                StoneSerializers.nullable(StoneSerializers.uInt64()).serialize(value.fileCount, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public FolderLogInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_fileCount;
            Long f_fileSize;
            String f_fileId;
            String f_displayName;
            PathLogInfo f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_displayName = null;
                f_fileId = null;
                f_fileSize = null;
                f_fileCount = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = (PathLogInfo)PathLogInfo.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("display_name".equals(field)) {
                        f_displayName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("file_id".equals(field)) {
                        f_fileId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("file_size".equals(field)) {
                        f_fileSize = StoneSerializers.nullable(StoneSerializers.uInt64()).deserialize(p);
                        continue;
                    }
                    if ("file_count".equals(field)) {
                        f_fileCount = StoneSerializers.nullable(StoneSerializers.uInt64()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FolderLogInfo value = new FolderLogInfo(f_path, f_displayName, f_fileId, f_fileSize, f_fileCount);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder
    extends FileOrFolderLogInfo.Builder {
        protected Long fileCount = null;

        protected Builder(PathLogInfo path) {
            super(path);
        }

        public Builder withFileCount(Long fileCount) {
            this.fileCount = fileCount;
            return this;
        }

        @Override
        public Builder withDisplayName(String displayName) {
            super.withDisplayName(displayName);
            return this;
        }

        @Override
        public Builder withFileId(String fileId) {
            super.withFileId(fileId);
            return this;
        }

        @Override
        public Builder withFileSize(Long fileSize) {
            super.withFileSize(fileSize);
            return this;
        }

        @Override
        public FolderLogInfo build() {
            return new FolderLogInfo(this.path, this.displayName, this.fileId, this.fileSize, this.fileCount);
        }
    }
}

