/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamcommon;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum GroupManagementType {
    USER_MANAGED,
    COMPANY_MANAGED,
    SYSTEM_MANAGED,
    OTHER;


    public static class Serializer
    extends UnionSerializer<GroupManagementType> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(GroupManagementType value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value) {
                case USER_MANAGED: {
                    g2.writeString("user_managed");
                    break;
                }
                case COMPANY_MANAGED: {
                    g2.writeString("company_managed");
                    break;
                }
                case SYSTEM_MANAGED: {
                    g2.writeString("system_managed");
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public GroupManagementType deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            GroupManagementType value = "user_managed".equals(tag) ? USER_MANAGED : ("company_managed".equals(tag) ? COMPANY_MANAGED : ("system_managed".equals(tag) ? SYSTEM_MANAGED : OTHER));
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

