/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.fileproperties.InvalidPropertyGroupError;
import com.dropbox.core.v2.files.UploadWriteFailed;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class UploadErrorWithProperties {
    public static final UploadErrorWithProperties OTHER = new UploadErrorWithProperties().withTag(Tag.OTHER);
    private Tag _tag;
    private UploadWriteFailed pathValue;
    private InvalidPropertyGroupError propertiesErrorValue;

    private UploadErrorWithProperties() {
    }

    private UploadErrorWithProperties withTag(Tag _tag) {
        UploadErrorWithProperties result = new UploadErrorWithProperties();
        result._tag = _tag;
        return result;
    }

    private UploadErrorWithProperties withTagAndPath(Tag _tag, UploadWriteFailed pathValue) {
        UploadErrorWithProperties result = new UploadErrorWithProperties();
        result._tag = _tag;
        result.pathValue = pathValue;
        return result;
    }

    private UploadErrorWithProperties withTagAndPropertiesError(Tag _tag, InvalidPropertyGroupError propertiesErrorValue) {
        UploadErrorWithProperties result = new UploadErrorWithProperties();
        result._tag = _tag;
        result.propertiesErrorValue = propertiesErrorValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isPath() {
        return this._tag == Tag.PATH;
    }

    public static UploadErrorWithProperties path(UploadWriteFailed value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UploadErrorWithProperties().withTagAndPath(Tag.PATH, value);
    }

    public UploadWriteFailed getPathValue() {
        if (this._tag != Tag.PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH, but was Tag." + this._tag.name());
        }
        return this.pathValue;
    }

    public boolean isPropertiesError() {
        return this._tag == Tag.PROPERTIES_ERROR;
    }

    public static UploadErrorWithProperties propertiesError(InvalidPropertyGroupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UploadErrorWithProperties().withTagAndPropertiesError(Tag.PROPERTIES_ERROR, value);
    }

    public InvalidPropertyGroupError getPropertiesErrorValue() {
        if (this._tag != Tag.PROPERTIES_ERROR) {
            throw new IllegalStateException("Invalid tag: required Tag.PROPERTIES_ERROR, but was Tag." + this._tag.name());
        }
        return this.propertiesErrorValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.pathValue, this.propertiesErrorValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof UploadErrorWithProperties) {
            UploadErrorWithProperties other = (UploadErrorWithProperties)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case PATH: {
                    return this.pathValue == other.pathValue || this.pathValue.equals(other.pathValue);
                }
                case PROPERTIES_ERROR: {
                    return this.propertiesErrorValue == other.propertiesErrorValue || this.propertiesErrorValue.equals(other.propertiesErrorValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<UploadErrorWithProperties> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UploadErrorWithProperties value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case PATH: {
                    g2.writeStartObject();
                    this.writeTag("path", g2);
                    UploadWriteFailed.Serializer.INSTANCE.serialize(value.pathValue, g2, true);
                    g2.writeEndObject();
                    break;
                }
                case PROPERTIES_ERROR: {
                    g2.writeStartObject();
                    this.writeTag("properties_error", g2);
                    g2.writeFieldName("properties_error");
                    InvalidPropertyGroupError.Serializer.INSTANCE.serialize(value.propertiesErrorValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case OTHER: {
                    g2.writeString("other");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public UploadErrorWithProperties deserialize(JsonParser p) throws IOException, JsonParseException {
            UploadErrorWithProperties value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("path".equals(tag)) {
                UploadWriteFailed fieldValue = null;
                fieldValue = UploadWriteFailed.Serializer.INSTANCE.deserialize(p, true);
                value = UploadErrorWithProperties.path(fieldValue);
            } else if ("properties_error".equals(tag)) {
                InvalidPropertyGroupError fieldValue = null;
                Serializer.expectField("properties_error", p);
                fieldValue = InvalidPropertyGroupError.Serializer.INSTANCE.deserialize(p);
                value = UploadErrorWithProperties.propertiesError(fieldValue);
            } else if ("other".equals(tag)) {
                value = OTHER;
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        PATH,
        PROPERTIES_ERROR,
        OTHER;

    }
}

