/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum ThumbnailMode {
    STRICT,
    BESTFIT,
    FITONE_BESTFIT;


    static class Serializer
    extends UnionSerializer<ThumbnailMode> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ThumbnailMode value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value) {
                case STRICT: {
                    g2.writeString("strict");
                    break;
                }
                case BESTFIT: {
                    g2.writeString("bestfit");
                    break;
                }
                case FITONE_BESTFIT: {
                    g2.writeString("fitone_bestfit");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value));
                }
            }
        }

        @Override
        public ThumbnailMode deserialize(JsonParser p) throws IOException, JsonParseException {
            ThumbnailMode value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("strict".equals(tag)) {
                value = STRICT;
            } else if ("bestfit".equals(tag)) {
                value = BESTFIT;
            } else if ("fitone_bestfit".equals(tag)) {
                value = FITONE_BESTFIT;
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

