/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum SearchMode {
    FILENAME,
    FILENAME_AND_CONTENT,
    DELETED_FILENAME;


    static class Serializer
    extends UnionSerializer<SearchMode> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SearchMode value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value) {
                case FILENAME: {
                    g2.writeString("filename");
                    break;
                }
                case FILENAME_AND_CONTENT: {
                    g2.writeString("filename_and_content");
                    break;
                }
                case DELETED_FILENAME: {
                    g2.writeString("deleted_filename");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value));
                }
            }
        }

        @Override
        public SearchMode deserialize(JsonParser p) throws IOException, JsonParseException {
            SearchMode value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("filename".equals(tag)) {
                value = FILENAME;
            } else if ("filename_and_content".equals(tag)) {
                value = FILENAME_AND_CONTENT;
            } else if ("deleted_filename".equals(tag)) {
                value = DELETED_FILENAME;
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

