/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.account;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class PhotoSourceArg {
    public static final PhotoSourceArg OTHER = new PhotoSourceArg().withTag(Tag.OTHER);
    private Tag _tag;
    private String base64DataValue;

    private PhotoSourceArg() {
    }

    private PhotoSourceArg withTag(Tag _tag) {
        PhotoSourceArg result = new PhotoSourceArg();
        result._tag = _tag;
        return result;
    }

    private PhotoSourceArg withTagAndBase64Data(Tag _tag, String base64DataValue) {
        PhotoSourceArg result = new PhotoSourceArg();
        result._tag = _tag;
        result.base64DataValue = base64DataValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isBase64Data() {
        return this._tag == Tag.BASE64_DATA;
    }

    public static PhotoSourceArg base64Data(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new PhotoSourceArg().withTagAndBase64Data(Tag.BASE64_DATA, value);
    }

    public String getBase64DataValue() {
        if (this._tag != Tag.BASE64_DATA) {
            throw new IllegalStateException("Invalid tag: required Tag.BASE64_DATA, but was Tag." + this._tag.name());
        }
        return this.base64DataValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.base64DataValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof PhotoSourceArg) {
            PhotoSourceArg other = (PhotoSourceArg)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case BASE64_DATA: {
                    return this.base64DataValue == other.base64DataValue || this.base64DataValue.equals(other.base64DataValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends UnionSerializer<PhotoSourceArg> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(PhotoSourceArg value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case BASE64_DATA: {
                    g2.writeStartObject();
                    this.writeTag("base64_data", g2);
                    g2.writeFieldName("base64_data");
                    StoneSerializers.string().serialize(value.base64DataValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public PhotoSourceArg deserialize(JsonParser p) throws IOException, JsonParseException {
            PhotoSourceArg value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("base64_data".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("base64_data", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = PhotoSourceArg.base64Data(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        BASE64_DATA,
        OTHER;

    }
}

