/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.commands.commands;

import com.almightyalpaca.discord.jdabutler.Bot;
import com.almightyalpaca.discord.jdabutler.commands.Command;
import com.almightyalpaca.discord.jdabutler.util.EmbedUtil;
import com.kantenkugel.discordbot.jenkinsutil.JenkinsApi;
import com.kantenkugel.discordbot.jenkinsutil.JenkinsBuild;
import java.io.IOException;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.TextChannel;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.guild.GuildMessageReceivedEvent;

public class JarsCommand
extends Command {
    private static final String[] ALIASES = new String[]{"jar"};

    @Override
    public void dispatch(User sender, TextChannel channel, Message message, String content, GuildMessageReceivedEvent event) {
        EmbedBuilder eb = new EmbedBuilder();
        EmbedUtil.setColor(eb);
        eb.setAuthor("Latest JDA jars", null, EmbedUtil.getJDAIconUrl());
        eb.setTitle("\u200e", null);
        try {
            JenkinsBuild lastBuild = JenkinsApi.JDA_JENKINS.getLastSuccessfulBuild();
            if (lastBuild == null) {
                this.reply(event, "Could not get Artifact-data from CI!");
                return;
            }
            eb.addField("jar", "[download](" + lastBuild.artifacts.get("JDA").getLink() + ")", true);
            eb.addField("javadoc", "[download](" + lastBuild.artifacts.get("JDA-javadoc").getLink() + ")", true);
            eb.addField("sources", "[download](" + lastBuild.artifacts.get("JDA-sources").getLink() + ")", true);
            eb.addField("withDependencies", "[(normal)](" + lastBuild.artifacts.get("JDA-withDependencies").getLink() + ") [(no-opus)](" + lastBuild.artifacts.get("JDA-withDependencies-no-opus").getLink() + ")", true);
            this.reply(event, eb.build());
        }
        catch (IOException ex) {
            Bot.LOG.warn("Failed fetching latest build from Jenkins for Jars command", ex);
            this.reply(event, "CI was unreachable!");
        }
    }

    @Override
    public String[] getAliases() {
        return ALIASES;
    }

    @Override
    public String getHelp() {
        return "Displays links to all JAR files";
    }

    @Override
    public String getName() {
        return "jars";
    }
}

