/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum SharedLinkAccessLevel {
    NONE,
    READER,
    WRITER,
    OTHER;


    static class Serializer
    extends UnionSerializer<SharedLinkAccessLevel> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharedLinkAccessLevel value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value) {
                case NONE: {
                    g2.writeString("none");
                    break;
                }
                case READER: {
                    g2.writeString("reader");
                    break;
                }
                case WRITER: {
                    g2.writeString("writer");
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public SharedLinkAccessLevel deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            SharedLinkAccessLevel value = "none".equals(tag) ? NONE : ("reader".equals(tag) ? READER : ("writer".equals(tag) ? WRITER : OTHER));
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

