/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum ResolvedVisibility {
    PUBLIC,
    TEAM_ONLY,
    PASSWORD,
    TEAM_AND_PASSWORD,
    SHARED_FOLDER_ONLY,
    OTHER;


    static class Serializer
    extends UnionSerializer<ResolvedVisibility> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ResolvedVisibility value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value) {
                case PUBLIC: {
                    g2.writeString("public");
                    break;
                }
                case TEAM_ONLY: {
                    g2.writeString("team_only");
                    break;
                }
                case PASSWORD: {
                    g2.writeString("password");
                    break;
                }
                case TEAM_AND_PASSWORD: {
                    g2.writeString("team_and_password");
                    break;
                }
                case SHARED_FOLDER_ONLY: {
                    g2.writeString("shared_folder_only");
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public ResolvedVisibility deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            ResolvedVisibility value = "public".equals(tag) ? PUBLIC : ("team_only".equals(tag) ? TEAM_ONLY : ("password".equals(tag) ? PASSWORD : ("team_and_password".equals(tag) ? TEAM_AND_PASSWORD : ("shared_folder_only".equals(tag) ? SHARED_FOLDER_ONLY : OTHER))));
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

