/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.LocalizedText;
import com.dropbox.core.stone.StoneSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

final class ApiErrorResponse<T> {
    private final T error;
    private LocalizedText userMessage;

    public ApiErrorResponse(T error, LocalizedText userMessage) {
        if (error == null) {
            throw new NullPointerException("error");
        }
        this.error = error;
        this.userMessage = userMessage;
    }

    public T getError() {
        return this.error;
    }

    public LocalizedText getUserMessage() {
        return this.userMessage;
    }

    static final class Serializer<T>
    extends StoneSerializer<ApiErrorResponse<T>> {
        private StoneSerializer<T> errSerializer;

        public Serializer(StoneSerializer<T> errSerializer) {
            this.errSerializer = errSerializer;
        }

        @Override
        public void serialize(ApiErrorResponse<T> value, JsonGenerator g2) throws IOException, JsonGenerationException {
            throw new UnsupportedOperationException("Error wrapper serialization not supported.");
        }

        @Override
        public ApiErrorResponse<T> deserialize(JsonParser p) throws IOException, JsonParseException {
            Object error = null;
            LocalizedText userMessage = null;
            Serializer.expectStartObject(p);
            while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                String field = p.getCurrentName();
                p.nextToken();
                if ("error".equals(field)) {
                    error = this.errSerializer.deserialize(p);
                    continue;
                }
                if ("user_message".equals(field)) {
                    userMessage = LocalizedText.STONE_SERIALIZER.deserialize(p);
                    continue;
                }
                Serializer.skipValue(p);
            }
            if (error == null) {
                throw new JsonParseException(p, "Required field \"error\" missing.");
            }
            ApiErrorResponse<Object> value = new ApiErrorResponse<Object>(error, userMessage);
            Serializer.expectEndObject(p);
            return value;
        }
    }
}

