/*
 * Decompiled with CFR 0.152.
 */
package net.dv8tion.jda.api.interactions.components.selections;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.ComponentInteraction;
import net.dv8tion.jda.api.interactions.components.ComponentLayout;
import net.dv8tion.jda.api.interactions.components.selections.SelectOption;
import net.dv8tion.jda.api.interactions.components.selections.SelectionMenu;
import net.dv8tion.jda.api.requests.RestAction;

public interface SelectionMenuInteraction
extends ComponentInteraction {
    @Override
    @Nullable
    public SelectionMenu getComponent();

    @Nullable
    default public SelectionMenu getSelectionMenu() {
        return this.getComponent();
    }

    @Nullable
    default public List<SelectOption> getSelectedOptions() {
        SelectionMenu menu = this.getComponent();
        if (menu == null) {
            return null;
        }
        List<String> values = this.getValues();
        return menu.getOptions().stream().filter(it -> values.contains(it.getValue())).collect(Collectors.toList());
    }

    @Nonnull
    public List<String> getValues();

    @Nonnull
    @CheckReturnValue
    default public RestAction<Void> editSelectionMenu(@Nullable SelectionMenu newMenu) {
        Message message = this.getMessage();
        if (message == null) {
            throw new IllegalStateException("Cannot update selection menu for ephemeral messages! Discord does not provide enough information to perform the update.");
        }
        ArrayList<ActionRow> components = new ArrayList<ActionRow>(message.getActionRows());
        ComponentLayout.updateComponent(components, this.getComponentId(), newMenu);
        if (this.isAcknowledged()) {
            return this.getHook().editMessageComponentsById(message.getId(), components).map(it -> null);
        }
        return this.editComponents(components).map(it -> null);
    }
}

