/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class GroupMembersAddError {
    public static final GroupMembersAddError GROUP_NOT_FOUND = new GroupMembersAddError().withTag(Tag.GROUP_NOT_FOUND);
    public static final GroupMembersAddError OTHER = new GroupMembersAddError().withTag(Tag.OTHER);
    public static final GroupMembersAddError SYSTEM_MANAGED_GROUP_DISALLOWED = new GroupMembersAddError().withTag(Tag.SYSTEM_MANAGED_GROUP_DISALLOWED);
    public static final GroupMembersAddError DUPLICATE_USER = new GroupMembersAddError().withTag(Tag.DUPLICATE_USER);
    public static final GroupMembersAddError GROUP_NOT_IN_TEAM = new GroupMembersAddError().withTag(Tag.GROUP_NOT_IN_TEAM);
    public static final GroupMembersAddError USER_MUST_BE_ACTIVE_TO_BE_OWNER = new GroupMembersAddError().withTag(Tag.USER_MUST_BE_ACTIVE_TO_BE_OWNER);
    private Tag _tag;
    private List<String> membersNotInTeamValue;
    private List<String> usersNotFoundValue;
    private List<String> userCannotBeManagerOfCompanyManagedGroupValue;

    private GroupMembersAddError() {
    }

    private GroupMembersAddError withTag(Tag _tag) {
        GroupMembersAddError result = new GroupMembersAddError();
        result._tag = _tag;
        return result;
    }

    private GroupMembersAddError withTagAndMembersNotInTeam(Tag _tag, List<String> membersNotInTeamValue) {
        GroupMembersAddError result = new GroupMembersAddError();
        result._tag = _tag;
        result.membersNotInTeamValue = membersNotInTeamValue;
        return result;
    }

    private GroupMembersAddError withTagAndUsersNotFound(Tag _tag, List<String> usersNotFoundValue) {
        GroupMembersAddError result = new GroupMembersAddError();
        result._tag = _tag;
        result.usersNotFoundValue = usersNotFoundValue;
        return result;
    }

    private GroupMembersAddError withTagAndUserCannotBeManagerOfCompanyManagedGroup(Tag _tag, List<String> userCannotBeManagerOfCompanyManagedGroupValue) {
        GroupMembersAddError result = new GroupMembersAddError();
        result._tag = _tag;
        result.userCannotBeManagerOfCompanyManagedGroupValue = userCannotBeManagerOfCompanyManagedGroupValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isGroupNotFound() {
        return this._tag == Tag.GROUP_NOT_FOUND;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public boolean isSystemManagedGroupDisallowed() {
        return this._tag == Tag.SYSTEM_MANAGED_GROUP_DISALLOWED;
    }

    public boolean isDuplicateUser() {
        return this._tag == Tag.DUPLICATE_USER;
    }

    public boolean isGroupNotInTeam() {
        return this._tag == Tag.GROUP_NOT_IN_TEAM;
    }

    public boolean isMembersNotInTeam() {
        return this._tag == Tag.MEMBERS_NOT_IN_TEAM;
    }

    public static GroupMembersAddError membersNotInTeam(List<String> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (String x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new GroupMembersAddError().withTagAndMembersNotInTeam(Tag.MEMBERS_NOT_IN_TEAM, value);
    }

    public List<String> getMembersNotInTeamValue() {
        if (this._tag != Tag.MEMBERS_NOT_IN_TEAM) {
            throw new IllegalStateException("Invalid tag: required Tag.MEMBERS_NOT_IN_TEAM, but was Tag." + this._tag.name());
        }
        return this.membersNotInTeamValue;
    }

    public boolean isUsersNotFound() {
        return this._tag == Tag.USERS_NOT_FOUND;
    }

    public static GroupMembersAddError usersNotFound(List<String> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (String x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new GroupMembersAddError().withTagAndUsersNotFound(Tag.USERS_NOT_FOUND, value);
    }

    public List<String> getUsersNotFoundValue() {
        if (this._tag != Tag.USERS_NOT_FOUND) {
            throw new IllegalStateException("Invalid tag: required Tag.USERS_NOT_FOUND, but was Tag." + this._tag.name());
        }
        return this.usersNotFoundValue;
    }

    public boolean isUserMustBeActiveToBeOwner() {
        return this._tag == Tag.USER_MUST_BE_ACTIVE_TO_BE_OWNER;
    }

    public boolean isUserCannotBeManagerOfCompanyManagedGroup() {
        return this._tag == Tag.USER_CANNOT_BE_MANAGER_OF_COMPANY_MANAGED_GROUP;
    }

    public static GroupMembersAddError userCannotBeManagerOfCompanyManagedGroup(List<String> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (String x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new GroupMembersAddError().withTagAndUserCannotBeManagerOfCompanyManagedGroup(Tag.USER_CANNOT_BE_MANAGER_OF_COMPANY_MANAGED_GROUP, value);
    }

    public List<String> getUserCannotBeManagerOfCompanyManagedGroupValue() {
        if (this._tag != Tag.USER_CANNOT_BE_MANAGER_OF_COMPANY_MANAGED_GROUP) {
            throw new IllegalStateException("Invalid tag: required Tag.USER_CANNOT_BE_MANAGER_OF_COMPANY_MANAGED_GROUP, but was Tag." + this._tag.name());
        }
        return this.userCannotBeManagerOfCompanyManagedGroupValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.membersNotInTeamValue, this.usersNotFoundValue, this.userCannotBeManagerOfCompanyManagedGroupValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof GroupMembersAddError) {
            GroupMembersAddError other = (GroupMembersAddError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case GROUP_NOT_FOUND: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
                case SYSTEM_MANAGED_GROUP_DISALLOWED: {
                    return true;
                }
                case DUPLICATE_USER: {
                    return true;
                }
                case GROUP_NOT_IN_TEAM: {
                    return true;
                }
                case MEMBERS_NOT_IN_TEAM: {
                    return this.membersNotInTeamValue == other.membersNotInTeamValue || this.membersNotInTeamValue.equals(other.membersNotInTeamValue);
                }
                case USERS_NOT_FOUND: {
                    return this.usersNotFoundValue == other.usersNotFoundValue || this.usersNotFoundValue.equals(other.usersNotFoundValue);
                }
                case USER_MUST_BE_ACTIVE_TO_BE_OWNER: {
                    return true;
                }
                case USER_CANNOT_BE_MANAGER_OF_COMPANY_MANAGED_GROUP: {
                    return this.userCannotBeManagerOfCompanyManagedGroupValue == other.userCannotBeManagerOfCompanyManagedGroupValue || this.userCannotBeManagerOfCompanyManagedGroupValue.equals(other.userCannotBeManagerOfCompanyManagedGroupValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<GroupMembersAddError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GroupMembersAddError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case GROUP_NOT_FOUND: {
                    g2.writeString("group_not_found");
                    break;
                }
                case OTHER: {
                    g2.writeString("other");
                    break;
                }
                case SYSTEM_MANAGED_GROUP_DISALLOWED: {
                    g2.writeString("system_managed_group_disallowed");
                    break;
                }
                case DUPLICATE_USER: {
                    g2.writeString("duplicate_user");
                    break;
                }
                case GROUP_NOT_IN_TEAM: {
                    g2.writeString("group_not_in_team");
                    break;
                }
                case MEMBERS_NOT_IN_TEAM: {
                    g2.writeStartObject();
                    this.writeTag("members_not_in_team", g2);
                    g2.writeFieldName("members_not_in_team");
                    StoneSerializers.list(StoneSerializers.string()).serialize((List<String>)value.membersNotInTeamValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case USERS_NOT_FOUND: {
                    g2.writeStartObject();
                    this.writeTag("users_not_found", g2);
                    g2.writeFieldName("users_not_found");
                    StoneSerializers.list(StoneSerializers.string()).serialize((List<String>)value.usersNotFoundValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case USER_MUST_BE_ACTIVE_TO_BE_OWNER: {
                    g2.writeString("user_must_be_active_to_be_owner");
                    break;
                }
                case USER_CANNOT_BE_MANAGER_OF_COMPANY_MANAGED_GROUP: {
                    g2.writeStartObject();
                    this.writeTag("user_cannot_be_manager_of_company_managed_group", g2);
                    g2.writeFieldName("user_cannot_be_manager_of_company_managed_group");
                    StoneSerializers.list(StoneSerializers.string()).serialize((List<String>)value.userCannotBeManagerOfCompanyManagedGroupValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public GroupMembersAddError deserialize(JsonParser p) throws IOException, JsonParseException {
            GroupMembersAddError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("group_not_found".equals(tag)) {
                value = GROUP_NOT_FOUND;
            } else if ("other".equals(tag)) {
                value = OTHER;
            } else if ("system_managed_group_disallowed".equals(tag)) {
                value = SYSTEM_MANAGED_GROUP_DISALLOWED;
            } else if ("duplicate_user".equals(tag)) {
                value = DUPLICATE_USER;
            } else if ("group_not_in_team".equals(tag)) {
                value = GROUP_NOT_IN_TEAM;
            } else if ("members_not_in_team".equals(tag)) {
                List<String> fieldValue = null;
                Serializer.expectField("members_not_in_team", p);
                fieldValue = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                value = GroupMembersAddError.membersNotInTeam(fieldValue);
            } else if ("users_not_found".equals(tag)) {
                List<String> fieldValue = null;
                Serializer.expectField("users_not_found", p);
                fieldValue = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                value = GroupMembersAddError.usersNotFound(fieldValue);
            } else if ("user_must_be_active_to_be_owner".equals(tag)) {
                value = USER_MUST_BE_ACTIVE_TO_BE_OWNER;
            } else if ("user_cannot_be_manager_of_company_managed_group".equals(tag)) {
                List<String> fieldValue = null;
                Serializer.expectField("user_cannot_be_manager_of_company_managed_group", p);
                fieldValue = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                value = GroupMembersAddError.userCannotBeManagerOfCompanyManagedGroup(fieldValue);
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        GROUP_NOT_FOUND,
        OTHER,
        SYSTEM_MANAGED_GROUP_DISALLOWED,
        DUPLICATE_USER,
        GROUP_NOT_IN_TEAM,
        MEMBERS_NOT_IN_TEAM,
        USERS_NOT_FOUND,
        USER_MUST_BE_ACTIVE_TO_BE_OWNER,
        USER_CANNOT_BE_MANAGER_OF_COMPANY_MANAGED_GROUP;

    }
}

