/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.fileproperties;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.fileproperties.LookUpPropertiesError;
import com.dropbox.core.v2.fileproperties.LookupError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class UpdatePropertiesError {
    public static final UpdatePropertiesError RESTRICTED_CONTENT = new UpdatePropertiesError().withTag(Tag.RESTRICTED_CONTENT);
    public static final UpdatePropertiesError OTHER = new UpdatePropertiesError().withTag(Tag.OTHER);
    public static final UpdatePropertiesError UNSUPPORTED_FOLDER = new UpdatePropertiesError().withTag(Tag.UNSUPPORTED_FOLDER);
    public static final UpdatePropertiesError PROPERTY_FIELD_TOO_LARGE = new UpdatePropertiesError().withTag(Tag.PROPERTY_FIELD_TOO_LARGE);
    public static final UpdatePropertiesError DOES_NOT_FIT_TEMPLATE = new UpdatePropertiesError().withTag(Tag.DOES_NOT_FIT_TEMPLATE);
    public static final UpdatePropertiesError DUPLICATE_PROPERTY_GROUPS = new UpdatePropertiesError().withTag(Tag.DUPLICATE_PROPERTY_GROUPS);
    private Tag _tag;
    private String templateNotFoundValue;
    private LookupError pathValue;
    private LookUpPropertiesError propertyGroupLookupValue;

    private UpdatePropertiesError() {
    }

    private UpdatePropertiesError withTag(Tag _tag) {
        UpdatePropertiesError result = new UpdatePropertiesError();
        result._tag = _tag;
        return result;
    }

    private UpdatePropertiesError withTagAndTemplateNotFound(Tag _tag, String templateNotFoundValue) {
        UpdatePropertiesError result = new UpdatePropertiesError();
        result._tag = _tag;
        result.templateNotFoundValue = templateNotFoundValue;
        return result;
    }

    private UpdatePropertiesError withTagAndPath(Tag _tag, LookupError pathValue) {
        UpdatePropertiesError result = new UpdatePropertiesError();
        result._tag = _tag;
        result.pathValue = pathValue;
        return result;
    }

    private UpdatePropertiesError withTagAndPropertyGroupLookup(Tag _tag, LookUpPropertiesError propertyGroupLookupValue) {
        UpdatePropertiesError result = new UpdatePropertiesError();
        result._tag = _tag;
        result.propertyGroupLookupValue = propertyGroupLookupValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isTemplateNotFound() {
        return this._tag == Tag.TEMPLATE_NOT_FOUND;
    }

    public static UpdatePropertiesError templateNotFound(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() < 1) {
            throw new IllegalArgumentException("String is shorter than 1");
        }
        if (!Pattern.matches("(/|ptid:).*", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new UpdatePropertiesError().withTagAndTemplateNotFound(Tag.TEMPLATE_NOT_FOUND, value);
    }

    public String getTemplateNotFoundValue() {
        if (this._tag != Tag.TEMPLATE_NOT_FOUND) {
            throw new IllegalStateException("Invalid tag: required Tag.TEMPLATE_NOT_FOUND, but was Tag." + this._tag.name());
        }
        return this.templateNotFoundValue;
    }

    public boolean isRestrictedContent() {
        return this._tag == Tag.RESTRICTED_CONTENT;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public boolean isPath() {
        return this._tag == Tag.PATH;
    }

    public static UpdatePropertiesError path(LookupError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UpdatePropertiesError().withTagAndPath(Tag.PATH, value);
    }

    public LookupError getPathValue() {
        if (this._tag != Tag.PATH) {
            throw new IllegalStateException("Invalid tag: required Tag.PATH, but was Tag." + this._tag.name());
        }
        return this.pathValue;
    }

    public boolean isUnsupportedFolder() {
        return this._tag == Tag.UNSUPPORTED_FOLDER;
    }

    public boolean isPropertyFieldTooLarge() {
        return this._tag == Tag.PROPERTY_FIELD_TOO_LARGE;
    }

    public boolean isDoesNotFitTemplate() {
        return this._tag == Tag.DOES_NOT_FIT_TEMPLATE;
    }

    public boolean isDuplicatePropertyGroups() {
        return this._tag == Tag.DUPLICATE_PROPERTY_GROUPS;
    }

    public boolean isPropertyGroupLookup() {
        return this._tag == Tag.PROPERTY_GROUP_LOOKUP;
    }

    public static UpdatePropertiesError propertyGroupLookup(LookUpPropertiesError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new UpdatePropertiesError().withTagAndPropertyGroupLookup(Tag.PROPERTY_GROUP_LOOKUP, value);
    }

    public LookUpPropertiesError getPropertyGroupLookupValue() {
        if (this._tag != Tag.PROPERTY_GROUP_LOOKUP) {
            throw new IllegalStateException("Invalid tag: required Tag.PROPERTY_GROUP_LOOKUP, but was Tag." + this._tag.name());
        }
        return this.propertyGroupLookupValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.templateNotFoundValue, this.pathValue, this.propertyGroupLookupValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof UpdatePropertiesError) {
            UpdatePropertiesError other = (UpdatePropertiesError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case TEMPLATE_NOT_FOUND: {
                    return this.templateNotFoundValue == other.templateNotFoundValue || this.templateNotFoundValue.equals(other.templateNotFoundValue);
                }
                case RESTRICTED_CONTENT: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
                case PATH: {
                    return this.pathValue == other.pathValue || this.pathValue.equals(other.pathValue);
                }
                case UNSUPPORTED_FOLDER: {
                    return true;
                }
                case PROPERTY_FIELD_TOO_LARGE: {
                    return true;
                }
                case DOES_NOT_FIT_TEMPLATE: {
                    return true;
                }
                case DUPLICATE_PROPERTY_GROUPS: {
                    return true;
                }
                case PROPERTY_GROUP_LOOKUP: {
                    return this.propertyGroupLookupValue == other.propertyGroupLookupValue || this.propertyGroupLookupValue.equals((Object)other.propertyGroupLookupValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends UnionSerializer<UpdatePropertiesError> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(UpdatePropertiesError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case TEMPLATE_NOT_FOUND: {
                    g2.writeStartObject();
                    this.writeTag("template_not_found", g2);
                    g2.writeFieldName("template_not_found");
                    StoneSerializers.string().serialize(value.templateNotFoundValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case RESTRICTED_CONTENT: {
                    g2.writeString("restricted_content");
                    break;
                }
                case OTHER: {
                    g2.writeString("other");
                    break;
                }
                case PATH: {
                    g2.writeStartObject();
                    this.writeTag("path", g2);
                    g2.writeFieldName("path");
                    LookupError.Serializer.INSTANCE.serialize(value.pathValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case UNSUPPORTED_FOLDER: {
                    g2.writeString("unsupported_folder");
                    break;
                }
                case PROPERTY_FIELD_TOO_LARGE: {
                    g2.writeString("property_field_too_large");
                    break;
                }
                case DOES_NOT_FIT_TEMPLATE: {
                    g2.writeString("does_not_fit_template");
                    break;
                }
                case DUPLICATE_PROPERTY_GROUPS: {
                    g2.writeString("duplicate_property_groups");
                    break;
                }
                case PROPERTY_GROUP_LOOKUP: {
                    g2.writeStartObject();
                    this.writeTag("property_group_lookup", g2);
                    g2.writeFieldName("property_group_lookup");
                    LookUpPropertiesError.Serializer.INSTANCE.serialize(value.propertyGroupLookupValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public UpdatePropertiesError deserialize(JsonParser p) throws IOException, JsonParseException {
            UpdatePropertiesError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("template_not_found".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("template_not_found", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = UpdatePropertiesError.templateNotFound(fieldValue);
            } else if ("restricted_content".equals(tag)) {
                value = RESTRICTED_CONTENT;
            } else if ("other".equals(tag)) {
                value = OTHER;
            } else if ("path".equals(tag)) {
                LookupError fieldValue = null;
                Serializer.expectField("path", p);
                fieldValue = LookupError.Serializer.INSTANCE.deserialize(p);
                value = UpdatePropertiesError.path(fieldValue);
            } else if ("unsupported_folder".equals(tag)) {
                value = UNSUPPORTED_FOLDER;
            } else if ("property_field_too_large".equals(tag)) {
                value = PROPERTY_FIELD_TOO_LARGE;
            } else if ("does_not_fit_template".equals(tag)) {
                value = DOES_NOT_FIT_TEMPLATE;
            } else if ("duplicate_property_groups".equals(tag)) {
                value = DUPLICATE_PROPERTY_GROUPS;
            } else if ("property_group_lookup".equals(tag)) {
                LookUpPropertiesError fieldValue = null;
                Serializer.expectField("property_group_lookup", p);
                fieldValue = LookUpPropertiesError.Serializer.INSTANCE.deserialize(p);
                value = UpdatePropertiesError.propertyGroupLookup(fieldValue);
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        TEMPLATE_NOT_FOUND,
        RESTRICTED_CONTENT,
        OTHER,
        PATH,
        UNSUPPORTED_FOLDER,
        PROPERTY_FIELD_TOO_LARGE,
        DOES_NOT_FIT_TEMPLATE,
        DUPLICATE_PROPERTY_GROUPS,
        PROPERTY_GROUP_LOOKUP;

    }
}

