/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core;

import com.dropbox.core.DbxAppInfo;
import com.dropbox.core.json.JsonReadException;
import com.dropbox.core.json.JsonReader;
import com.dropbox.core.util.StringUtil;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public final class DbxAuthFinish {
    private final String accessToken;
    private final Long expiresIn;
    private final String refreshToken;
    private final String userId;
    private final String accountId;
    private final String teamId;
    private final String urlState;
    private long issueTime;
    private final String scope;
    public static final JsonReader<DbxAuthFinish> Reader = new JsonReader<DbxAuthFinish>(){

        @Override
        public DbxAuthFinish read(JsonParser parser) throws IOException, JsonReadException {
            JsonLocation top = JsonReader.expectObjectStart(parser);
            String accessToken = null;
            Long expiresIn = null;
            String refreshToken = null;
            String tokenType = null;
            String userId = null;
            String accountId = null;
            String teamId = null;
            String state = null;
            String scope = null;
            while (parser.getCurrentToken() == JsonToken.FIELD_NAME) {
                String fieldName = parser.getCurrentName();
                JsonReader.nextToken(parser);
                try {
                    if (fieldName.equals("token_type")) {
                        tokenType = BearerTokenTypeReader.readField(parser, fieldName, tokenType);
                        continue;
                    }
                    if (fieldName.equals("access_token")) {
                        accessToken = AccessTokenReader.readField(parser, fieldName, accessToken);
                        continue;
                    }
                    if (fieldName.equals("expires_in")) {
                        expiresIn = JsonReader.UInt64Reader.readField(parser, fieldName, expiresIn);
                        continue;
                    }
                    if (fieldName.equals("refresh_token")) {
                        refreshToken = JsonReader.StringReader.readField(parser, fieldName, refreshToken);
                        continue;
                    }
                    if (fieldName.equals("uid")) {
                        userId = JsonReader.StringReader.readField(parser, fieldName, userId);
                        continue;
                    }
                    if (fieldName.equals("account_id")) {
                        accountId = JsonReader.StringReader.readField(parser, fieldName, accountId);
                        continue;
                    }
                    if (fieldName.equals("team_id")) {
                        teamId = JsonReader.StringReader.readField(parser, fieldName, teamId);
                        continue;
                    }
                    if (fieldName.equals("state")) {
                        state = JsonReader.StringReader.readField(parser, fieldName, state);
                        continue;
                    }
                    if (fieldName.equals("scope")) {
                        scope = JsonReader.StringReader.readField(parser, fieldName, scope);
                        continue;
                    }
                    JsonReader.skipValue(parser);
                }
                catch (JsonReadException ex) {
                    throw ex.addFieldContext(fieldName);
                }
            }
            JsonReader.expectObjectEnd(parser);
            if (tokenType == null) {
                throw new JsonReadException("missing field \"token_type\"", top);
            }
            if (accessToken == null) {
                throw new JsonReadException("missing field \"access_token\"", top);
            }
            if (userId == null) {
                throw new JsonReadException("missing field \"uid\"", top);
            }
            if (accountId == null && teamId == null) {
                throw new JsonReadException("missing field \"account_id\" and missing field \"team_id\"", top);
            }
            if (refreshToken != null && expiresIn == null) {
                throw new JsonReadException("missing field \"expires_in\"", top);
            }
            return new DbxAuthFinish(accessToken, expiresIn, refreshToken, userId, teamId, accountId, state, scope);
        }
    };
    public static final JsonReader<String> BearerTokenTypeReader = new JsonReader<String>(){

        @Override
        public String read(JsonParser parser) throws IOException, JsonReadException {
            try {
                String v = parser.getText();
                if (!v.equals("Bearer") && !v.equals("bearer")) {
                    throw new JsonReadException("expecting \"Bearer\": got " + StringUtil.jq(v), parser.getTokenLocation());
                }
                parser.nextToken();
                return v;
            }
            catch (JsonParseException ex) {
                throw JsonReadException.fromJackson(ex);
            }
        }
    };
    public static final JsonReader<String> AccessTokenReader = new JsonReader<String>(){

        @Override
        public String read(JsonParser parser) throws IOException, JsonReadException {
            try {
                String v = parser.getText();
                String error = DbxAppInfo.getTokenPartError(v);
                if (error != null) {
                    throw new JsonReadException(error, parser.getTokenLocation());
                }
                parser.nextToken();
                return v;
            }
            catch (JsonParseException ex) {
                throw JsonReadException.fromJackson(ex);
            }
        }
    };

    @Deprecated
    public DbxAuthFinish(String accessToken, String userId, String accountId, String teamId, String urlState) {
        this(accessToken, null, null, userId, teamId, accountId, urlState);
    }

    public DbxAuthFinish(String accessToken, Long expiresIn, String refreshToken, String userId, String teamId, String accountId, String urlState) {
        this(accessToken, expiresIn, refreshToken, userId, teamId, accountId, urlState, null);
    }

    public DbxAuthFinish(String accessToken, Long expiresIn, String refreshToken, String userId, String teamId, String accountId, String urlState, String scope) {
        this.accessToken = accessToken;
        this.expiresIn = expiresIn;
        this.refreshToken = refreshToken;
        this.userId = userId;
        this.accountId = accountId;
        this.teamId = teamId;
        this.urlState = urlState;
        this.issueTime = System.currentTimeMillis();
        this.scope = scope;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public Long getExpiresAt() {
        if (this.expiresIn == null) {
            return null;
        }
        return this.issueTime + this.expiresIn * 1000L;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getTeamId() {
        return this.teamId;
    }

    public String getScope() {
        return this.scope;
    }

    public String getUrlState() {
        return this.urlState;
    }

    void setIssueTime(long issueTime) {
        this.issueTime = issueTime;
    }

    DbxAuthFinish withUrlState(String urlState) {
        if (this.urlState != null) {
            throw new IllegalStateException("Already have URL state.");
        }
        DbxAuthFinish result = new DbxAuthFinish(this.accessToken, this.expiresIn, this.refreshToken, this.userId, this.teamId, this.accountId, urlState, this.scope);
        result.setIssueTime(this.issueTime);
        return result;
    }
}

