/*
 * Decompiled with CFR 0.152.
 */
package com.kantenkugel.discordbot.versioncheck;

import com.kantenkugel.discordbot.jenkinsutil.JenkinsApi;
import com.kantenkugel.discordbot.jenkinsutil.JenkinsBuild;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Supplier;

public class JenkinsVersionSupplier
implements Supplier<String> {
    private final JenkinsApi jenkins;
    private final boolean useBuildNumber;

    public JenkinsVersionSupplier(JenkinsApi jenkins) {
        this(jenkins, false);
    }

    public JenkinsVersionSupplier(JenkinsApi jenkins, boolean useBuildNumber) {
        this.jenkins = jenkins;
        this.useBuildNumber = useBuildNumber;
    }

    @Override
    public String get() {
        try {
            JenkinsBuild build = this.jenkins.fetchLastSuccessfulBuild();
            if (build == null) {
                return null;
            }
            if (!this.useBuildNumber && build.artifacts.size() > 0) {
                JenkinsBuild.Artifact firstArtifact = build.artifacts.values().iterator().next();
                return firstArtifact.fileNameParts.get(1);
            }
            return Integer.toString(build.buildNum);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

