/*
 * Decompiled with CFR 0.152.
 */
package com.kantenkugel.discordbot.jdocparser;

import com.kantenkugel.discordbot.jdocparser.JDocParser;
import com.kantenkugel.discordbot.jenkinsutil.JenkinsApi;
import com.overzealous.remark.Options;
import com.overzealous.remark.Remark;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDocUtil {
    static final Logger LOG = LoggerFactory.getLogger("JDoc");
    static final Path LOCAL_DOC_PATH = Paths.get("jda-docs.jar", new String[0]);
    public static final String JAVA_JDOCS_PREFIX = "https://docs.oracle.com/javase/8/docs/api/";
    static final String JAVA_JDOCS_CLASS_INDEX = "https://docs.oracle.com/javase/8/docs/api/allclasses-noframe.html";
    public static final String JDOCBASE = JenkinsApi.JDA_JENKINS.jenkinsBase + "javadoc/";
    static final String JDA_CODE_BASE = "net/dv8tion/jda";
    private static final Remark REMARK;
    private static final Pattern CODEBLOCK_PATTERN;

    static String formatText(String docs, String currentUrl) {
        String markdown = REMARK.convertFragment(JDocUtil.fixSpaces(docs), currentUrl);
        markdown = markdown.replace("\r", "");
        Matcher matcher = CODEBLOCK_PATTERN.matcher(markdown = markdown.replace("\n\n```", "\n\n```java"));
        if (matcher.find()) {
            StringBuffer buffer = new StringBuffer();
            do {
                matcher.appendReplacement(buffer, matcher.group(1) + matcher.group(2).replaceAll("\n\\s", "\n") + matcher.group(3));
            } while (matcher.find());
            matcher.appendTail(buffer);
            markdown = buffer.toString();
        }
        markdown = markdown.replaceAll("\n{3,}", "\n\n");
        return markdown;
    }

    static String fixSpaces(String input) {
        return input == null ? null : input.replaceAll("\\h", " ");
    }

    static String getLink(String jdocBase, JDocParser.ClassDocumentation doc) {
        return JDocUtil.getLink(jdocBase, doc.pack, doc.className);
    }

    static String getLink(String jdocBase, String classPackage, String className) {
        return jdocBase + classPackage.replace(".", "/") + '/' + className + ".html";
    }

    static String fixUrl(String url) {
        return url.replace(")", "%29");
    }

    static String fixSignature(String sig) {
        return sig.replace("\u200b", "").replaceAll("\\b(?:[a-z]+\\.)+([A-Z])", "$1").replaceAll("\\s{2,}", " ");
    }

    static {
        CODEBLOCK_PATTERN = Pattern.compile("(```java\n)(.*?)(```)", 32);
        Options remarkOptions = Options.github();
        remarkOptions.inlineLinks = true;
        remarkOptions.fencedCodeBlocksWidth = 3;
        REMARK = new Remark(remarkOptions);
    }
}

