/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.sharing.InsufficientPlan;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class PermissionDeniedReason {
    public static final PermissionDeniedReason USER_NOT_SAME_TEAM_AS_OWNER = new PermissionDeniedReason().withTag(Tag.USER_NOT_SAME_TEAM_AS_OWNER);
    public static final PermissionDeniedReason USER_NOT_ALLOWED_BY_OWNER = new PermissionDeniedReason().withTag(Tag.USER_NOT_ALLOWED_BY_OWNER);
    public static final PermissionDeniedReason TARGET_IS_INDIRECT_MEMBER = new PermissionDeniedReason().withTag(Tag.TARGET_IS_INDIRECT_MEMBER);
    public static final PermissionDeniedReason TARGET_IS_OWNER = new PermissionDeniedReason().withTag(Tag.TARGET_IS_OWNER);
    public static final PermissionDeniedReason TARGET_IS_SELF = new PermissionDeniedReason().withTag(Tag.TARGET_IS_SELF);
    public static final PermissionDeniedReason TARGET_NOT_ACTIVE = new PermissionDeniedReason().withTag(Tag.TARGET_NOT_ACTIVE);
    public static final PermissionDeniedReason FOLDER_IS_LIMITED_TEAM_FOLDER = new PermissionDeniedReason().withTag(Tag.FOLDER_IS_LIMITED_TEAM_FOLDER);
    public static final PermissionDeniedReason OWNER_NOT_ON_TEAM = new PermissionDeniedReason().withTag(Tag.OWNER_NOT_ON_TEAM);
    public static final PermissionDeniedReason PERMISSION_DENIED = new PermissionDeniedReason().withTag(Tag.PERMISSION_DENIED);
    public static final PermissionDeniedReason RESTRICTED_BY_TEAM = new PermissionDeniedReason().withTag(Tag.RESTRICTED_BY_TEAM);
    public static final PermissionDeniedReason USER_ACCOUNT_TYPE = new PermissionDeniedReason().withTag(Tag.USER_ACCOUNT_TYPE);
    public static final PermissionDeniedReason USER_NOT_ON_TEAM = new PermissionDeniedReason().withTag(Tag.USER_NOT_ON_TEAM);
    public static final PermissionDeniedReason FOLDER_IS_INSIDE_SHARED_FOLDER = new PermissionDeniedReason().withTag(Tag.FOLDER_IS_INSIDE_SHARED_FOLDER);
    public static final PermissionDeniedReason RESTRICTED_BY_PARENT_FOLDER = new PermissionDeniedReason().withTag(Tag.RESTRICTED_BY_PARENT_FOLDER);
    public static final PermissionDeniedReason OTHER = new PermissionDeniedReason().withTag(Tag.OTHER);
    private Tag _tag;
    private InsufficientPlan insufficientPlanValue;

    private PermissionDeniedReason() {
    }

    private PermissionDeniedReason withTag(Tag _tag) {
        PermissionDeniedReason result = new PermissionDeniedReason();
        result._tag = _tag;
        return result;
    }

    private PermissionDeniedReason withTagAndInsufficientPlan(Tag _tag, InsufficientPlan insufficientPlanValue) {
        PermissionDeniedReason result = new PermissionDeniedReason();
        result._tag = _tag;
        result.insufficientPlanValue = insufficientPlanValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isUserNotSameTeamAsOwner() {
        return this._tag == Tag.USER_NOT_SAME_TEAM_AS_OWNER;
    }

    public boolean isUserNotAllowedByOwner() {
        return this._tag == Tag.USER_NOT_ALLOWED_BY_OWNER;
    }

    public boolean isTargetIsIndirectMember() {
        return this._tag == Tag.TARGET_IS_INDIRECT_MEMBER;
    }

    public boolean isTargetIsOwner() {
        return this._tag == Tag.TARGET_IS_OWNER;
    }

    public boolean isTargetIsSelf() {
        return this._tag == Tag.TARGET_IS_SELF;
    }

    public boolean isTargetNotActive() {
        return this._tag == Tag.TARGET_NOT_ACTIVE;
    }

    public boolean isFolderIsLimitedTeamFolder() {
        return this._tag == Tag.FOLDER_IS_LIMITED_TEAM_FOLDER;
    }

    public boolean isOwnerNotOnTeam() {
        return this._tag == Tag.OWNER_NOT_ON_TEAM;
    }

    public boolean isPermissionDenied() {
        return this._tag == Tag.PERMISSION_DENIED;
    }

    public boolean isRestrictedByTeam() {
        return this._tag == Tag.RESTRICTED_BY_TEAM;
    }

    public boolean isUserAccountType() {
        return this._tag == Tag.USER_ACCOUNT_TYPE;
    }

    public boolean isUserNotOnTeam() {
        return this._tag == Tag.USER_NOT_ON_TEAM;
    }

    public boolean isFolderIsInsideSharedFolder() {
        return this._tag == Tag.FOLDER_IS_INSIDE_SHARED_FOLDER;
    }

    public boolean isRestrictedByParentFolder() {
        return this._tag == Tag.RESTRICTED_BY_PARENT_FOLDER;
    }

    public boolean isInsufficientPlan() {
        return this._tag == Tag.INSUFFICIENT_PLAN;
    }

    public static PermissionDeniedReason insufficientPlan(InsufficientPlan value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new PermissionDeniedReason().withTagAndInsufficientPlan(Tag.INSUFFICIENT_PLAN, value);
    }

    public InsufficientPlan getInsufficientPlanValue() {
        if (this._tag != Tag.INSUFFICIENT_PLAN) {
            throw new IllegalStateException("Invalid tag: required Tag.INSUFFICIENT_PLAN, but was Tag." + this._tag.name());
        }
        return this.insufficientPlanValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.insufficientPlanValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof PermissionDeniedReason) {
            PermissionDeniedReason other = (PermissionDeniedReason)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case USER_NOT_SAME_TEAM_AS_OWNER: {
                    return true;
                }
                case USER_NOT_ALLOWED_BY_OWNER: {
                    return true;
                }
                case TARGET_IS_INDIRECT_MEMBER: {
                    return true;
                }
                case TARGET_IS_OWNER: {
                    return true;
                }
                case TARGET_IS_SELF: {
                    return true;
                }
                case TARGET_NOT_ACTIVE: {
                    return true;
                }
                case FOLDER_IS_LIMITED_TEAM_FOLDER: {
                    return true;
                }
                case OWNER_NOT_ON_TEAM: {
                    return true;
                }
                case PERMISSION_DENIED: {
                    return true;
                }
                case RESTRICTED_BY_TEAM: {
                    return true;
                }
                case USER_ACCOUNT_TYPE: {
                    return true;
                }
                case USER_NOT_ON_TEAM: {
                    return true;
                }
                case FOLDER_IS_INSIDE_SHARED_FOLDER: {
                    return true;
                }
                case RESTRICTED_BY_PARENT_FOLDER: {
                    return true;
                }
                case INSUFFICIENT_PLAN: {
                    return this.insufficientPlanValue == other.insufficientPlanValue || this.insufficientPlanValue.equals(other.insufficientPlanValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<PermissionDeniedReason> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(PermissionDeniedReason value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case USER_NOT_SAME_TEAM_AS_OWNER: {
                    g2.writeString("user_not_same_team_as_owner");
                    break;
                }
                case USER_NOT_ALLOWED_BY_OWNER: {
                    g2.writeString("user_not_allowed_by_owner");
                    break;
                }
                case TARGET_IS_INDIRECT_MEMBER: {
                    g2.writeString("target_is_indirect_member");
                    break;
                }
                case TARGET_IS_OWNER: {
                    g2.writeString("target_is_owner");
                    break;
                }
                case TARGET_IS_SELF: {
                    g2.writeString("target_is_self");
                    break;
                }
                case TARGET_NOT_ACTIVE: {
                    g2.writeString("target_not_active");
                    break;
                }
                case FOLDER_IS_LIMITED_TEAM_FOLDER: {
                    g2.writeString("folder_is_limited_team_folder");
                    break;
                }
                case OWNER_NOT_ON_TEAM: {
                    g2.writeString("owner_not_on_team");
                    break;
                }
                case PERMISSION_DENIED: {
                    g2.writeString("permission_denied");
                    break;
                }
                case RESTRICTED_BY_TEAM: {
                    g2.writeString("restricted_by_team");
                    break;
                }
                case USER_ACCOUNT_TYPE: {
                    g2.writeString("user_account_type");
                    break;
                }
                case USER_NOT_ON_TEAM: {
                    g2.writeString("user_not_on_team");
                    break;
                }
                case FOLDER_IS_INSIDE_SHARED_FOLDER: {
                    g2.writeString("folder_is_inside_shared_folder");
                    break;
                }
                case RESTRICTED_BY_PARENT_FOLDER: {
                    g2.writeString("restricted_by_parent_folder");
                    break;
                }
                case INSUFFICIENT_PLAN: {
                    g2.writeStartObject();
                    this.writeTag("insufficient_plan", g2);
                    InsufficientPlan.Serializer.INSTANCE.serialize(value.insufficientPlanValue, g2, true);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public PermissionDeniedReason deserialize(JsonParser p) throws IOException, JsonParseException {
            PermissionDeniedReason value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("user_not_same_team_as_owner".equals(tag)) {
                value = USER_NOT_SAME_TEAM_AS_OWNER;
            } else if ("user_not_allowed_by_owner".equals(tag)) {
                value = USER_NOT_ALLOWED_BY_OWNER;
            } else if ("target_is_indirect_member".equals(tag)) {
                value = TARGET_IS_INDIRECT_MEMBER;
            } else if ("target_is_owner".equals(tag)) {
                value = TARGET_IS_OWNER;
            } else if ("target_is_self".equals(tag)) {
                value = TARGET_IS_SELF;
            } else if ("target_not_active".equals(tag)) {
                value = TARGET_NOT_ACTIVE;
            } else if ("folder_is_limited_team_folder".equals(tag)) {
                value = FOLDER_IS_LIMITED_TEAM_FOLDER;
            } else if ("owner_not_on_team".equals(tag)) {
                value = OWNER_NOT_ON_TEAM;
            } else if ("permission_denied".equals(tag)) {
                value = PERMISSION_DENIED;
            } else if ("restricted_by_team".equals(tag)) {
                value = RESTRICTED_BY_TEAM;
            } else if ("user_account_type".equals(tag)) {
                value = USER_ACCOUNT_TYPE;
            } else if ("user_not_on_team".equals(tag)) {
                value = USER_NOT_ON_TEAM;
            } else if ("folder_is_inside_shared_folder".equals(tag)) {
                value = FOLDER_IS_INSIDE_SHARED_FOLDER;
            } else if ("restricted_by_parent_folder".equals(tag)) {
                value = RESTRICTED_BY_PARENT_FOLDER;
            } else if ("insufficient_plan".equals(tag)) {
                InsufficientPlan fieldValue = null;
                fieldValue = InsufficientPlan.Serializer.INSTANCE.deserialize(p, true);
                value = PermissionDeniedReason.insufficientPlan(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        USER_NOT_SAME_TEAM_AS_OWNER,
        USER_NOT_ALLOWED_BY_OWNER,
        TARGET_IS_INDIRECT_MEMBER,
        TARGET_IS_OWNER,
        TARGET_IS_SELF,
        TARGET_NOT_ACTIVE,
        FOLDER_IS_LIMITED_TEAM_FOLDER,
        OWNER_NOT_ON_TEAM,
        PERMISSION_DENIED,
        RESTRICTED_BY_TEAM,
        USER_ACCOUNT_TYPE,
        USER_NOT_ON_TEAM,
        FOLDER_IS_INSIDE_SHARED_FOLDER,
        RESTRICTED_BY_PARENT_FOLDER,
        INSUFFICIENT_PLAN,
        OTHER;

    }
}

