/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.AudienceExceptionContentInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class AudienceExceptions {
    protected final long count;
    protected final List<AudienceExceptionContentInfo> exceptions;

    public AudienceExceptions(long count, List<AudienceExceptionContentInfo> exceptions) {
        this.count = count;
        if (exceptions == null) {
            throw new IllegalArgumentException("Required value for 'exceptions' is null");
        }
        for (AudienceExceptionContentInfo x : exceptions) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'exceptions' is null");
        }
        this.exceptions = exceptions;
    }

    public long getCount() {
        return this.count;
    }

    public List<AudienceExceptionContentInfo> getExceptions() {
        return this.exceptions;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.count, this.exceptions});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            AudienceExceptions other = (AudienceExceptions)obj;
            return this.count == other.count && (this.exceptions == other.exceptions || this.exceptions.equals(other.exceptions));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<AudienceExceptions> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(AudienceExceptions value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("count");
            StoneSerializers.uInt32().serialize((Long)value.count, g2);
            g2.writeFieldName("exceptions");
            StoneSerializers.list(AudienceExceptionContentInfo.Serializer.INSTANCE).serialize(value.exceptions, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public AudienceExceptions deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<AudienceExceptionContentInfo> f_exceptions;
            Long f_count;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_count = null;
                f_exceptions = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("count".equals(field)) {
                        f_count = StoneSerializers.uInt32().deserialize(p);
                        continue;
                    }
                    if ("exceptions".equals(field)) {
                        f_exceptions = StoneSerializers.list(AudienceExceptionContentInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_count == null) {
                    throw new JsonParseException(p, "Required field \"count\" missing.");
                }
                if (f_exceptions == null) {
                    throw new JsonParseException(p, "Required field \"exceptions\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            AudienceExceptions value = new AudienceExceptions(f_count, f_exceptions);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

