/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.util.LangUtil;
import com.dropbox.core.v2.files.Dimensions;
import com.dropbox.core.v2.files.GpsCoordinates;
import com.dropbox.core.v2.files.PhotoMetadata;
import com.dropbox.core.v2.files.VideoMetadata;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class MediaMetadata {
    protected final Dimensions dimensions;
    protected final GpsCoordinates location;
    protected final Date timeTaken;

    public MediaMetadata(Dimensions dimensions, GpsCoordinates location, Date timeTaken) {
        this.dimensions = dimensions;
        this.location = location;
        this.timeTaken = LangUtil.truncateMillis(timeTaken);
    }

    public MediaMetadata() {
        this(null, null, null);
    }

    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public GpsCoordinates getLocation() {
        return this.location;
    }

    public Date getTimeTaken() {
        return this.timeTaken;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.dimensions, this.location, this.timeTaken});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            MediaMetadata other = (MediaMetadata)obj;
            return (this.dimensions == other.dimensions || this.dimensions != null && this.dimensions.equals(other.dimensions)) && (this.location == other.location || this.location != null && this.location.equals(other.location)) && (this.timeTaken == other.timeTaken || this.timeTaken != null && this.timeTaken.equals(other.timeTaken));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<MediaMetadata> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MediaMetadata value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (value instanceof PhotoMetadata) {
                PhotoMetadata.Serializer.INSTANCE.serialize((PhotoMetadata)value, g2, collapse);
                return;
            }
            if (value instanceof VideoMetadata) {
                VideoMetadata.Serializer.INSTANCE.serialize((VideoMetadata)value, g2, collapse);
                return;
            }
            if (!collapse) {
                g2.writeStartObject();
            }
            if (value.dimensions != null) {
                g2.writeFieldName("dimensions");
                StoneSerializers.nullableStruct(Dimensions.Serializer.INSTANCE).serialize(value.dimensions, g2);
            }
            if (value.location != null) {
                g2.writeFieldName("location");
                StoneSerializers.nullableStruct(GpsCoordinates.Serializer.INSTANCE).serialize(value.location, g2);
            }
            if (value.timeTaken != null) {
                g2.writeFieldName("time_taken");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.timeTaken, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public MediaMetadata deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            MediaMetadata value;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
                if ("".equals(tag)) {
                    tag = null;
                }
            }
            if (tag == null) {
                Dimensions f_dimensions = null;
                GpsCoordinates f_location = null;
                Date f_timeTaken = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("dimensions".equals(field)) {
                        f_dimensions = StoneSerializers.nullableStruct(Dimensions.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("location".equals(field)) {
                        f_location = StoneSerializers.nullableStruct(GpsCoordinates.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("time_taken".equals(field)) {
                        f_timeTaken = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                value = new MediaMetadata(f_dimensions, f_location, f_timeTaken);
            } else if ("".equals(tag)) {
                value = INSTANCE.deserialize(p, true);
            } else if ("photo".equals(tag)) {
                value = PhotoMetadata.Serializer.INSTANCE.deserialize(p, true);
            } else if ("video".equals(tag)) {
                value = VideoMetadata.Serializer.INSTANCE.deserialize(p, true);
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected Dimensions dimensions = null;
        protected GpsCoordinates location = null;
        protected Date timeTaken = null;

        protected Builder() {
        }

        public Builder withDimensions(Dimensions dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public Builder withLocation(GpsCoordinates location) {
            this.location = location;
            return this;
        }

        public Builder withTimeTaken(Date timeTaken) {
            this.timeTaken = LangUtil.truncateMillis(timeTaken);
            return this;
        }

        public MediaMetadata build() {
            return new MediaMetadata(this.dimensions, this.location, this.timeTaken);
        }
    }
}

