/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum FileCategory {
    IMAGE,
    DOCUMENT,
    PDF,
    SPREADSHEET,
    PRESENTATION,
    AUDIO,
    VIDEO,
    FOLDER,
    PAPER,
    OTHERS,
    OTHER;


    static class Serializer
    extends UnionSerializer<FileCategory> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileCategory value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value) {
                case IMAGE: {
                    g2.writeString("image");
                    break;
                }
                case DOCUMENT: {
                    g2.writeString("document");
                    break;
                }
                case PDF: {
                    g2.writeString("pdf");
                    break;
                }
                case SPREADSHEET: {
                    g2.writeString("spreadsheet");
                    break;
                }
                case PRESENTATION: {
                    g2.writeString("presentation");
                    break;
                }
                case AUDIO: {
                    g2.writeString("audio");
                    break;
                }
                case VIDEO: {
                    g2.writeString("video");
                    break;
                }
                case FOLDER: {
                    g2.writeString("folder");
                    break;
                }
                case PAPER: {
                    g2.writeString("paper");
                    break;
                }
                case OTHERS: {
                    g2.writeString("others");
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public FileCategory deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            FileCategory value = "image".equals(tag) ? IMAGE : ("document".equals(tag) ? DOCUMENT : ("pdf".equals(tag) ? PDF : ("spreadsheet".equals(tag) ? SPREADSHEET : ("presentation".equals(tag) ? PRESENTATION : ("audio".equals(tag) ? AUDIO : ("video".equals(tag) ? VIDEO : ("folder".equals(tag) ? FOLDER : ("paper".equals(tag) ? PAPER : ("others".equals(tag) ? OTHERS : OTHER)))))))));
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

