/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.clouddocs;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum CloudDocsAccessError {
    INVALID_DOC_ID,
    NOT_FOUND,
    PERMISSION_DENIED,
    OTHER;


    static class Serializer
    extends UnionSerializer<CloudDocsAccessError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(CloudDocsAccessError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value) {
                case INVALID_DOC_ID: {
                    g2.writeString("invalid_doc_id");
                    break;
                }
                case NOT_FOUND: {
                    g2.writeString("not_found");
                    break;
                }
                case PERMISSION_DENIED: {
                    g2.writeString("permission_denied");
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public CloudDocsAccessError deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            CloudDocsAccessError value = "invalid_doc_id".equals(tag) ? INVALID_DOC_ID : ("not_found".equals(tag) ? NOT_FOUND : ("permission_denied".equals(tag) ? PERMISSION_DENIED : OTHER));
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

