/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.util;

import com.almightyalpaca.discord.jdabutler.Bot;
import com.kantenkugel.discordbot.jenkinsutil.JenkinsUser;
import java.text.DateFormat;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.entities.User;

public class FormattingUtil {
    public static String formatTimestamp(long timestamp) {
        return DateFormat.getDateTimeInstance(1, 2, Locale.ENGLISH).format(Date.from(Instant.ofEpochMilli(timestamp)));
    }

    public static void setFooter(EmbedBuilder eb, List<JenkinsUser> culprits, OffsetDateTime timestamp) {
        eb.setTimestamp(timestamp);
        if (culprits.size() == 1) {
            JenkinsUser author = culprits.get(0);
            String description = author.description;
            if (description != null) {
                User user = null;
                String friendlyName = null;
                for (String line : description.split("\r?\n")) {
                    if (line.startsWith("discord:")) {
                        try {
                            user = Bot.jda.getUserById(line.substring(8).trim());
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            continue;
                        }
                    }
                    if (!line.startsWith("name:")) continue;
                    friendlyName = line.substring(5).trim();
                }
                if (user != null) {
                    eb.setFooter(user.getName(), user.getAvatarUrl());
                } else if (friendlyName != null) {
                    eb.setFooter(friendlyName, null);
                } else {
                    eb.setFooter(author.toString(), null);
                }
            } else {
                eb.setFooter(author.toString(), null);
            }
        } else if (culprits.size() > 1) {
            eb.setFooter("Multiple users", null);
        } else {
            eb.setFooter("Unknown user", null);
        }
    }
}

