/*
 * Decompiled with CFR 0.152.
 */
package com.almightyalpaca.discord.jdabutler.commands;

import com.almightyalpaca.discord.jdabutler.util.MiscUtils;
import gnu.trove.map.TLongObjectMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.dv8tion.jda.api.Permission;
import net.dv8tion.jda.api.entities.ChannelType;
import net.dv8tion.jda.api.entities.Emote;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageReaction;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.events.message.react.MessageReactionAddEvent;
import net.dv8tion.jda.api.exceptions.ErrorResponseException;
import net.dv8tion.jda.api.exceptions.PermissionException;
import net.dv8tion.jda.api.requests.ErrorResponse;
import net.dv8tion.jda.api.utils.MiscUtil;

public class ReactionListenerRegistry {
    private static final ScheduledExecutorService EXECUTOR = Executors.newScheduledThreadPool(5, MiscUtils.newThreadFactory("reaction-listener"));
    private final TLongObjectMap<ReactionListener> listeners = MiscUtil.newLongMap();

    ReactionListenerRegistry() {
    }

    boolean hasListener(long messageId) {
        return this.listeners.containsKey(messageId);
    }

    void newListener(Message message, List<String> allowedReactions, Set<User> allowedUsers, int timeout, TimeUnit timeUnit, Consumer<Integer> callback) {
        new ReactionListener(message, allowedReactions, allowedUsers, timeout, timeUnit, callback);
    }

    private void register(long messageId, ReactionListener listener) {
        this.listeners.put(messageId, listener);
    }

    private void remove(long messageId) {
        this.listeners.remove(messageId);
    }

    void handle(MessageReactionAddEvent event) {
        ReactionListener[] safeValues;
        for (ReactionListener listener : safeValues = this.listeners.values((ReactionListener[])new ReactionListener[this.listeners.size()])) {
            listener.handle(event);
        }
    }

    void cancel(long messageId) {
        this.cancel(messageId, false);
    }

    void cancel(long messageId, boolean removeReactions) {
        ReactionListener reactionListener = this.listeners.get(messageId);
        if (reactionListener != null) {
            reactionListener.stop(removeReactions);
        }
    }

    private final class ReactionListener {
        private final Message message;
        private final List<String> allowedReactions;
        private final Set<User> allowedUsers;
        private final Consumer<Integer> callback;
        private final ScheduledFuture<?> timeoutFuture;
        private boolean shouldDeleteReactions = true;

        private ReactionListener(Message message, List<String> allowedReactions, Set<User> allowedUsers, int timeout, TimeUnit timeUnit, Consumer<Integer> callback) {
            ReactionListenerRegistry.this.register(message.getIdLong(), this);
            this.message = message;
            this.allowedReactions = allowedReactions;
            this.allowedUsers = allowedUsers;
            this.callback = callback;
            this.timeoutFuture = EXECUTOR.schedule(this::cleanup, (long)timeout, timeUnit);
            this.addReactions();
        }

        private void handle(MessageReactionAddEvent event) {
            String reaction;
            if (event.getMessageIdLong() != this.message.getIdLong()) {
                return;
            }
            if (event.getUser() == event.getJDA().getSelfUser()) {
                return;
            }
            try {
                event.getReaction().removeReaction(event.getUser()).queue(null, ErrorResponseException.ignore(ErrorResponse.UNKNOWN_MESSAGE, new ErrorResponse[0]));
            }
            catch (PermissionException permissionException) {
                // empty catch block
            }
            if (!this.allowedUsers.isEmpty() && !this.allowedUsers.contains(event.getUser())) {
                return;
            }
            MessageReaction.ReactionEmote reactionEmote = event.getReactionEmote();
            String string = reaction = reactionEmote.isEmote() ? reactionEmote.getEmote().getId() : reactionEmote.getName();
            if (this.allowedReactions.contains(reaction)) {
                this.callback.accept(this.allowedReactions.indexOf(reaction));
            }
        }

        private void addReactions() {
            if (this.message.getChannelType() == ChannelType.TEXT && !this.message.getGuild().getSelfMember().hasPermission(Permission.MESSAGE_ADD_REACTION)) {
                return;
            }
            for (String reaction : this.allowedReactions) {
                Emote emote = null;
                try {
                    emote = this.message.getJDA().getEmoteById(reaction);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (emote == null) {
                    this.message.addReaction(reaction).queue();
                    continue;
                }
                this.message.addReaction(emote).queue();
            }
        }

        private void stop(boolean removeReactions) {
            this.shouldDeleteReactions = removeReactions;
            this.timeoutFuture.cancel(true);
            this.cleanup();
        }

        private void cleanup() {
            ReactionListenerRegistry.this.remove(this.message.getIdLong());
            if (this.shouldDeleteReactions) {
                try {
                    this.message.clearReactions().queue();
                }
                catch (PermissionException permissionException) {
                    // empty catch block
                }
            }
        }
    }
}

