/*
 * Decompiled with CFR 0.152.
 */
package com.kantenkugel.discordbot.versioncheck.items;

import com.almightyalpaca.discord.jdabutler.Bot;
import com.kantenkugel.discordbot.jenkinsutil.JenkinsApi;
import com.kantenkugel.discordbot.jenkinsutil.JenkinsBuild;
import com.kantenkugel.discordbot.versioncheck.JenkinsVersionSupplier;
import com.kantenkugel.discordbot.versioncheck.RepoType;
import com.kantenkugel.discordbot.versioncheck.UpdateHandler;
import com.kantenkugel.discordbot.versioncheck.items.VersionedItem;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import okhttp3.Request;
import okhttp3.Response;

public class ButlerItem
extends VersionedItem
implements UpdateHandler {
    private static final int UPDATE_CODE = 101;
    private static final Path UPDATE_FILE = Paths.get("Bot_Update.jar", new String[0]);
    private static final JenkinsApi JENKINS = JenkinsApi.forConfig("https://ci.dv8tion.net", "JDA-Butler");
    private static final JenkinsVersionSupplier VERSION_SUPPLIER = new JenkinsVersionSupplier(JENKINS, true);
    private static final List<String> ALIASES = Collections.singletonList("butler");

    @Override
    public String getName() {
        return "JDA-Butler";
    }

    @Override
    public RepoType getRepoType() {
        return null;
    }

    @Override
    public String getGroupId() {
        return null;
    }

    @Override
    public String getArtifactId() {
        return null;
    }

    @Override
    public List<String> getAliases() {
        return ALIASES;
    }

    @Override
    public String getUrl() {
        return "https://github.com/Almighty-Alpaca/JDA-Butler";
    }

    @Override
    public UpdateHandler getUpdateHandler() {
        return this;
    }

    @Override
    public Supplier<String> getCustomVersionSupplier() {
        return VERSION_SUPPLIER;
    }

    @Override
    public void onUpdate(VersionedItem item, String previousVersion, boolean shouldAnnounce) {
        Bot.LOG.warn("Updating Butler to new build #{}", (Object)item.getVersion());
        try {
            JenkinsBuild lastSuccessfulBuild = JENKINS.fetchLastSuccessfulBuild();
            if (lastSuccessfulBuild == null) {
                Bot.LOG.error("For some reason, the latest build was null");
                return;
            }
            JenkinsBuild.Artifact bot = lastSuccessfulBuild.artifacts.get("Bot");
            if (bot == null) {
                Bot.LOG.error("Could not find required artifact (Bot) in {}", (Object)lastSuccessfulBuild.artifacts);
                return;
            }
            Bot.LOG.info("Downloading new Butler version...");
            try (Response res = Bot.httpClient.newCall(new Request.Builder().url(bot.getLink()).get().build()).execute();){
                if (!res.isSuccessful()) {
                    Bot.LOG.warn("OkHttp returned failure for {}", (Object)bot.getLink());
                    return;
                }
                Files.copy(res.body().byteStream(), UPDATE_FILE, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                Bot.LOG.error("Error downloading new Butler version", e);
                return;
            }
            Bot.LOG.info("Exiting with update code ({})", (Object)101);
            Bot.shutdown(101);
        }
        catch (IOException e) {
            Bot.LOG.error("Could not get latest Butler build", e);
        }
    }
}

