/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.UserSelectorArg;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class UserSecondaryEmailsArg {
    protected final UserSelectorArg user;
    protected final List<String> secondaryEmails;

    public UserSecondaryEmailsArg(UserSelectorArg user, List<String> secondaryEmails) {
        if (user == null) {
            throw new IllegalArgumentException("Required value for 'user' is null");
        }
        this.user = user;
        if (secondaryEmails == null) {
            throw new IllegalArgumentException("Required value for 'secondaryEmails' is null");
        }
        for (String x : secondaryEmails) {
            if (x == null) {
                throw new IllegalArgumentException("An item in list 'secondaryEmails' is null");
            }
            if (x.length() > 255) {
                throw new IllegalArgumentException("Stringan item in list 'secondaryEmails' is longer than 255");
            }
            if (Pattern.matches("^['&A-Za-z0-9._%+-]+@[A-Za-z0-9-][A-Za-z0-9.-]*\\.[A-Za-z]{2,15}$", x)) continue;
            throw new IllegalArgumentException("Stringan item in list 'secondaryEmails' does not match pattern");
        }
        this.secondaryEmails = secondaryEmails;
    }

    public UserSelectorArg getUser() {
        return this.user;
    }

    public List<String> getSecondaryEmails() {
        return this.secondaryEmails;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.user, this.secondaryEmails});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            UserSecondaryEmailsArg other = (UserSecondaryEmailsArg)obj;
            return !(this.user != other.user && !this.user.equals(other.user) || this.secondaryEmails != other.secondaryEmails && !this.secondaryEmails.equals(other.secondaryEmails));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<UserSecondaryEmailsArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(UserSecondaryEmailsArg value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("user");
            UserSelectorArg.Serializer.INSTANCE.serialize(value.user, g2);
            g2.writeFieldName("secondary_emails");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.secondaryEmails, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public UserSecondaryEmailsArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            List<String> f_secondaryEmails;
            UserSelectorArg f_user;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_user = null;
                f_secondaryEmails = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("user".equals(field)) {
                        f_user = UserSelectorArg.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("secondary_emails".equals(field)) {
                        f_secondaryEmails = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_user == null) {
                    throw new JsonParseException(p, "Required field \"user\" missing.");
                }
                if (f_secondaryEmails == null) {
                    throw new JsonParseException(p, "Required field \"secondary_emails\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            UserSecondaryEmailsArg value = new UserSecondaryEmailsArg(f_user, f_secondaryEmails);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

