/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;

public enum WriteConflictError {
    FILE,
    FOLDER,
    FILE_ANCESTOR,
    OTHER;


    static class Serializer
    extends UnionSerializer<WriteConflictError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(WriteConflictError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value) {
                case FILE: {
                    g2.writeString("file");
                    break;
                }
                case FOLDER: {
                    g2.writeString("folder");
                    break;
                }
                case FILE_ANCESTOR: {
                    g2.writeString("file_ancestor");
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public WriteConflictError deserialize(JsonParser p) throws IOException, JsonParseException {
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            WriteConflictError value = "file".equals(tag) ? FILE : ("folder".equals(tag) ? FOLDER : ("file_ancestor".equals(tag) ? FILE_ANCESTOR : OTHER));
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

