/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.files.ListRevisionsMode;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

class ListRevisionsArg {
    protected final String path;
    protected final ListRevisionsMode mode;
    protected final long limit;

    public ListRevisionsArg(String path, ListRevisionsMode mode, long limit) {
        if (path == null) {
            throw new IllegalArgumentException("Required value for 'path' is null");
        }
        if (!Pattern.matches("/(.|[\\r\\n])*|id:.*|(ns:[0-9]+(/.*)?)", path)) {
            throw new IllegalArgumentException("String 'path' does not match pattern");
        }
        this.path = path;
        if (mode == null) {
            throw new IllegalArgumentException("Required value for 'mode' is null");
        }
        this.mode = mode;
        if (limit < 1L) {
            throw new IllegalArgumentException("Number 'limit' is smaller than 1L");
        }
        if (limit > 100L) {
            throw new IllegalArgumentException("Number 'limit' is larger than 100L");
        }
        this.limit = limit;
    }

    public ListRevisionsArg(String path) {
        this(path, ListRevisionsMode.PATH, 10L);
    }

    public String getPath() {
        return this.path;
    }

    public ListRevisionsMode getMode() {
        return this.mode;
    }

    public long getLimit() {
        return this.limit;
    }

    public static Builder newBuilder(String path) {
        return new Builder(path);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.path, this.mode, this.limit});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListRevisionsArg other = (ListRevisionsArg)obj;
            return !(this.path != other.path && !this.path.equals(other.path) || this.mode != other.mode && !this.mode.equals((Object)other.mode) || this.limit != other.limit);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ListRevisionsArg> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ListRevisionsArg value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("path");
            StoneSerializers.string().serialize(value.path, g2);
            g2.writeFieldName("mode");
            ListRevisionsMode.Serializer.INSTANCE.serialize(value.mode, g2);
            g2.writeFieldName("limit");
            StoneSerializers.uInt64().serialize((Long)value.limit, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public ListRevisionsArg deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Long f_limit;
            ListRevisionsMode f_mode;
            String f_path;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_path = null;
                f_mode = ListRevisionsMode.PATH;
                f_limit = 10L;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("path".equals(field)) {
                        f_path = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("mode".equals(field)) {
                        f_mode = ListRevisionsMode.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("limit".equals(field)) {
                        f_limit = StoneSerializers.uInt64().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_path == null) {
                    throw new JsonParseException(p, "Required field \"path\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ListRevisionsArg value = new ListRevisionsArg(f_path, f_mode, f_limit);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final String path;
        protected ListRevisionsMode mode;
        protected long limit;

        protected Builder(String path) {
            if (path == null) {
                throw new IllegalArgumentException("Required value for 'path' is null");
            }
            if (!Pattern.matches("/(.|[\\r\\n])*|id:.*|(ns:[0-9]+(/.*)?)", path)) {
                throw new IllegalArgumentException("String 'path' does not match pattern");
            }
            this.path = path;
            this.mode = ListRevisionsMode.PATH;
            this.limit = 10L;
        }

        public Builder withMode(ListRevisionsMode mode) {
            this.mode = mode != null ? mode : ListRevisionsMode.PATH;
            return this;
        }

        public Builder withLimit(Long limit) {
            if (limit < 1L) {
                throw new IllegalArgumentException("Number 'limit' is smaller than 1L");
            }
            if (limit > 100L) {
                throw new IllegalArgumentException("Number 'limit' is larger than 100L");
            }
            this.limit = limit != null ? limit : 10L;
            return this;
        }

        public ListRevisionsArg build() {
            return new ListRevisionsArg(this.path, this.mode, this.limit);
        }
    }
}

