/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class Certificate {
    protected final String subject;
    protected final String issuer;
    protected final String issueDate;
    protected final String expirationDate;
    protected final String serialNumber;
    protected final String sha1Fingerprint;
    protected final String commonName;

    public Certificate(String subject, String issuer, String issueDate, String expirationDate, String serialNumber, String sha1Fingerprint, String commonName) {
        if (subject == null) {
            throw new IllegalArgumentException("Required value for 'subject' is null");
        }
        this.subject = subject;
        if (issuer == null) {
            throw new IllegalArgumentException("Required value for 'issuer' is null");
        }
        this.issuer = issuer;
        if (issueDate == null) {
            throw new IllegalArgumentException("Required value for 'issueDate' is null");
        }
        this.issueDate = issueDate;
        if (expirationDate == null) {
            throw new IllegalArgumentException("Required value for 'expirationDate' is null");
        }
        this.expirationDate = expirationDate;
        if (serialNumber == null) {
            throw new IllegalArgumentException("Required value for 'serialNumber' is null");
        }
        this.serialNumber = serialNumber;
        if (sha1Fingerprint == null) {
            throw new IllegalArgumentException("Required value for 'sha1Fingerprint' is null");
        }
        this.sha1Fingerprint = sha1Fingerprint;
        this.commonName = commonName;
    }

    public Certificate(String subject, String issuer, String issueDate, String expirationDate, String serialNumber, String sha1Fingerprint) {
        this(subject, issuer, issueDate, expirationDate, serialNumber, sha1Fingerprint, null);
    }

    public String getSubject() {
        return this.subject;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getIssueDate() {
        return this.issueDate;
    }

    public String getExpirationDate() {
        return this.expirationDate;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getSha1Fingerprint() {
        return this.sha1Fingerprint;
    }

    public String getCommonName() {
        return this.commonName;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.subject, this.issuer, this.issueDate, this.expirationDate, this.serialNumber, this.sha1Fingerprint, this.commonName});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            Certificate other = (Certificate)obj;
            return !(this.subject != other.subject && !this.subject.equals(other.subject) || this.issuer != other.issuer && !this.issuer.equals(other.issuer) || this.issueDate != other.issueDate && !this.issueDate.equals(other.issueDate) || this.expirationDate != other.expirationDate && !this.expirationDate.equals(other.expirationDate) || this.serialNumber != other.serialNumber && !this.serialNumber.equals(other.serialNumber) || this.sha1Fingerprint != other.sha1Fingerprint && !this.sha1Fingerprint.equals(other.sha1Fingerprint) || this.commonName != other.commonName && (this.commonName == null || !this.commonName.equals(other.commonName)));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<Certificate> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(Certificate value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("subject");
            StoneSerializers.string().serialize(value.subject, g2);
            g2.writeFieldName("issuer");
            StoneSerializers.string().serialize(value.issuer, g2);
            g2.writeFieldName("issue_date");
            StoneSerializers.string().serialize(value.issueDate, g2);
            g2.writeFieldName("expiration_date");
            StoneSerializers.string().serialize(value.expirationDate, g2);
            g2.writeFieldName("serial_number");
            StoneSerializers.string().serialize(value.serialNumber, g2);
            g2.writeFieldName("sha1_fingerprint");
            StoneSerializers.string().serialize(value.sha1Fingerprint, g2);
            if (value.commonName != null) {
                g2.writeFieldName("common_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.commonName, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public Certificate deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_commonName;
            String f_sha1Fingerprint;
            String f_serialNumber;
            String f_expirationDate;
            String f_issueDate;
            String f_issuer;
            String f_subject;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_subject = null;
                f_issuer = null;
                f_issueDate = null;
                f_expirationDate = null;
                f_serialNumber = null;
                f_sha1Fingerprint = null;
                f_commonName = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("subject".equals(field)) {
                        f_subject = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("issuer".equals(field)) {
                        f_issuer = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("issue_date".equals(field)) {
                        f_issueDate = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("expiration_date".equals(field)) {
                        f_expirationDate = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("serial_number".equals(field)) {
                        f_serialNumber = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("sha1_fingerprint".equals(field)) {
                        f_sha1Fingerprint = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("common_name".equals(field)) {
                        f_commonName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_subject == null) {
                    throw new JsonParseException(p, "Required field \"subject\" missing.");
                }
                if (f_issuer == null) {
                    throw new JsonParseException(p, "Required field \"issuer\" missing.");
                }
                if (f_issueDate == null) {
                    throw new JsonParseException(p, "Required field \"issue_date\" missing.");
                }
                if (f_expirationDate == null) {
                    throw new JsonParseException(p, "Required field \"expiration_date\" missing.");
                }
                if (f_serialNumber == null) {
                    throw new JsonParseException(p, "Required field \"serial_number\" missing.");
                }
                if (f_sha1Fingerprint == null) {
                    throw new JsonParseException(p, "Required field \"sha1_fingerprint\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            Certificate value = new Certificate(f_subject, f_issuer, f_issueDate, f_expirationDate, f_serialNumber, f_sha1Fingerprint, f_commonName);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

