/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamlog.TeamLinkedAppLogInfo;
import com.dropbox.core.v2.teamlog.UserLinkedAppLogInfo;
import com.dropbox.core.v2.teamlog.UserOrTeamLinkedAppLogInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class AppLogInfo {
    protected final String appId;
    protected final String displayName;

    public AppLogInfo(String appId, String displayName) {
        this.appId = appId;
        this.displayName = displayName;
    }

    public AppLogInfo() {
        this(null, null);
    }

    public String getAppId() {
        return this.appId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.appId, this.displayName});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            AppLogInfo other = (AppLogInfo)obj;
            return (this.appId == other.appId || this.appId != null && this.appId.equals(other.appId)) && (this.displayName == other.displayName || this.displayName != null && this.displayName.equals(other.displayName));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<AppLogInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(AppLogInfo value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (value instanceof UserOrTeamLinkedAppLogInfo) {
                UserOrTeamLinkedAppLogInfo.Serializer.INSTANCE.serialize((UserOrTeamLinkedAppLogInfo)value, g2, collapse);
                return;
            }
            if (value instanceof UserLinkedAppLogInfo) {
                UserLinkedAppLogInfo.Serializer.INSTANCE.serialize((UserLinkedAppLogInfo)value, g2, collapse);
                return;
            }
            if (value instanceof TeamLinkedAppLogInfo) {
                TeamLinkedAppLogInfo.Serializer.INSTANCE.serialize((TeamLinkedAppLogInfo)value, g2, collapse);
                return;
            }
            if (!collapse) {
                g2.writeStartObject();
            }
            if (value.appId != null) {
                g2.writeFieldName("app_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.appId, g2);
            }
            if (value.displayName != null) {
                g2.writeFieldName("display_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.displayName, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public AppLogInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            AppLogInfo value;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
                if ("".equals(tag)) {
                    tag = null;
                }
            }
            if (tag == null) {
                String f_appId = null;
                String f_displayName = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("app_id".equals(field)) {
                        f_appId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("display_name".equals(field)) {
                        f_displayName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                value = new AppLogInfo(f_appId, f_displayName);
            } else if ("".equals(tag)) {
                value = INSTANCE.deserialize(p, true);
            } else if ("user_or_team_linked_app".equals(tag)) {
                value = UserOrTeamLinkedAppLogInfo.Serializer.INSTANCE.deserialize(p, true);
            } else if ("user_linked_app".equals(tag)) {
                value = UserLinkedAppLogInfo.Serializer.INSTANCE.deserialize(p, true);
            } else if ("team_linked_app".equals(tag)) {
                value = TeamLinkedAppLogInfo.Serializer.INSTANCE.deserialize(p, true);
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected String appId = null;
        protected String displayName = null;

        protected Builder() {
        }

        public Builder withAppId(String appId) {
            this.appId = appId;
            return this;
        }

        public Builder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public AppLogInfo build() {
            return new AppLogInfo(this.appId, this.displayName);
        }
    }
}

