/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.AccessLevel;
import com.dropbox.core.v2.sharing.AudienceExceptions;
import com.dropbox.core.v2.sharing.AudienceRestrictingSharedFolder;
import com.dropbox.core.v2.sharing.LinkAudience;
import com.dropbox.core.v2.sharing.LinkPermission;
import com.dropbox.core.v2.sharing.SharedContentLinkMetadataBase;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class SharedContentLinkMetadata
extends SharedContentLinkMetadataBase {
    protected final AudienceExceptions audienceExceptions;
    protected final String url;

    public SharedContentLinkMetadata(List<LinkAudience> audienceOptions, LinkAudience currentAudience, List<LinkPermission> linkPermissions, boolean passwordProtected, String url, AccessLevel accessLevel, AudienceRestrictingSharedFolder audienceRestrictingSharedFolder, Date expiry, AudienceExceptions audienceExceptions) {
        super(audienceOptions, currentAudience, linkPermissions, passwordProtected, accessLevel, audienceRestrictingSharedFolder, expiry);
        this.audienceExceptions = audienceExceptions;
        if (url == null) {
            throw new IllegalArgumentException("Required value for 'url' is null");
        }
        this.url = url;
    }

    public SharedContentLinkMetadata(List<LinkAudience> audienceOptions, LinkAudience currentAudience, List<LinkPermission> linkPermissions, boolean passwordProtected, String url) {
        this(audienceOptions, currentAudience, linkPermissions, passwordProtected, url, null, null, null, null);
    }

    @Override
    public List<LinkAudience> getAudienceOptions() {
        return this.audienceOptions;
    }

    @Override
    public LinkAudience getCurrentAudience() {
        return this.currentAudience;
    }

    @Override
    public List<LinkPermission> getLinkPermissions() {
        return this.linkPermissions;
    }

    @Override
    public boolean getPasswordProtected() {
        return this.passwordProtected;
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    @Override
    public AudienceRestrictingSharedFolder getAudienceRestrictingSharedFolder() {
        return this.audienceRestrictingSharedFolder;
    }

    @Override
    public Date getExpiry() {
        return this.expiry;
    }

    public AudienceExceptions getAudienceExceptions() {
        return this.audienceExceptions;
    }

    public static Builder newBuilder(List<LinkAudience> audienceOptions, LinkAudience currentAudience, List<LinkPermission> linkPermissions, boolean passwordProtected, String url) {
        return new Builder(audienceOptions, currentAudience, linkPermissions, passwordProtected, url);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.audienceExceptions, this.url});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            SharedContentLinkMetadata other = (SharedContentLinkMetadata)obj;
            return !(this.audienceOptions != other.audienceOptions && !this.audienceOptions.equals(other.audienceOptions) || this.currentAudience != other.currentAudience && !this.currentAudience.equals((Object)other.currentAudience) || this.linkPermissions != other.linkPermissions && !this.linkPermissions.equals(other.linkPermissions) || this.passwordProtected != other.passwordProtected || this.url != other.url && !this.url.equals(other.url) || this.accessLevel != other.accessLevel && (this.accessLevel == null || !this.accessLevel.equals((Object)other.accessLevel)) || this.audienceRestrictingSharedFolder != other.audienceRestrictingSharedFolder && (this.audienceRestrictingSharedFolder == null || !this.audienceRestrictingSharedFolder.equals(other.audienceRestrictingSharedFolder)) || this.expiry != other.expiry && (this.expiry == null || !this.expiry.equals(other.expiry)) || this.audienceExceptions != other.audienceExceptions && (this.audienceExceptions == null || !this.audienceExceptions.equals(other.audienceExceptions)));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<SharedContentLinkMetadata> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SharedContentLinkMetadata value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("audience_options");
            StoneSerializers.list(LinkAudience.Serializer.INSTANCE).serialize((List<LinkAudience>)value.audienceOptions, g2);
            g2.writeFieldName("current_audience");
            LinkAudience.Serializer.INSTANCE.serialize(value.currentAudience, g2);
            g2.writeFieldName("link_permissions");
            StoneSerializers.list(LinkPermission.Serializer.INSTANCE).serialize((List<LinkPermission>)value.linkPermissions, g2);
            g2.writeFieldName("password_protected");
            StoneSerializers.boolean_().serialize((Boolean)value.passwordProtected, g2);
            g2.writeFieldName("url");
            StoneSerializers.string().serialize(value.url, g2);
            if (value.accessLevel != null) {
                g2.writeFieldName("access_level");
                StoneSerializers.nullable(AccessLevel.Serializer.INSTANCE).serialize(value.accessLevel, g2);
            }
            if (value.audienceRestrictingSharedFolder != null) {
                g2.writeFieldName("audience_restricting_shared_folder");
                StoneSerializers.nullableStruct(AudienceRestrictingSharedFolder.Serializer.INSTANCE).serialize(value.audienceRestrictingSharedFolder, g2);
            }
            if (value.expiry != null) {
                g2.writeFieldName("expiry");
                StoneSerializers.nullable(StoneSerializers.timestamp()).serialize(value.expiry, g2);
            }
            if (value.audienceExceptions != null) {
                g2.writeFieldName("audience_exceptions");
                StoneSerializers.nullableStruct(AudienceExceptions.Serializer.INSTANCE).serialize(value.audienceExceptions, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public SharedContentLinkMetadata deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            AudienceExceptions f_audienceExceptions;
            Date f_expiry;
            AudienceRestrictingSharedFolder f_audienceRestrictingSharedFolder;
            AccessLevel f_accessLevel;
            String f_url;
            Boolean f_passwordProtected;
            List<LinkPermission> f_linkPermissions;
            LinkAudience f_currentAudience;
            List<LinkAudience> f_audienceOptions;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_audienceOptions = null;
                f_currentAudience = null;
                f_linkPermissions = null;
                f_passwordProtected = null;
                f_url = null;
                f_accessLevel = null;
                f_audienceRestrictingSharedFolder = null;
                f_expiry = null;
                f_audienceExceptions = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("audience_options".equals(field)) {
                        f_audienceOptions = StoneSerializers.list(LinkAudience.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("current_audience".equals(field)) {
                        f_currentAudience = LinkAudience.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("link_permissions".equals(field)) {
                        f_linkPermissions = StoneSerializers.list(LinkPermission.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("password_protected".equals(field)) {
                        f_passwordProtected = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("url".equals(field)) {
                        f_url = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("access_level".equals(field)) {
                        f_accessLevel = StoneSerializers.nullable(AccessLevel.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("audience_restricting_shared_folder".equals(field)) {
                        f_audienceRestrictingSharedFolder = StoneSerializers.nullableStruct(AudienceRestrictingSharedFolder.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("expiry".equals(field)) {
                        f_expiry = StoneSerializers.nullable(StoneSerializers.timestamp()).deserialize(p);
                        continue;
                    }
                    if ("audience_exceptions".equals(field)) {
                        f_audienceExceptions = StoneSerializers.nullableStruct(AudienceExceptions.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_audienceOptions == null) {
                    throw new JsonParseException(p, "Required field \"audience_options\" missing.");
                }
                if (f_currentAudience == null) {
                    throw new JsonParseException(p, "Required field \"current_audience\" missing.");
                }
                if (f_linkPermissions == null) {
                    throw new JsonParseException(p, "Required field \"link_permissions\" missing.");
                }
                if (f_passwordProtected == null) {
                    throw new JsonParseException(p, "Required field \"password_protected\" missing.");
                }
                if (f_url == null) {
                    throw new JsonParseException(p, "Required field \"url\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            SharedContentLinkMetadata value = new SharedContentLinkMetadata(f_audienceOptions, f_currentAudience, f_linkPermissions, f_passwordProtected, f_url, f_accessLevel, f_audienceRestrictingSharedFolder, f_expiry, f_audienceExceptions);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder
    extends SharedContentLinkMetadataBase.Builder {
        protected final String url;
        protected AudienceExceptions audienceExceptions;

        protected Builder(List<LinkAudience> audienceOptions, LinkAudience currentAudience, List<LinkPermission> linkPermissions, boolean passwordProtected, String url) {
            super(audienceOptions, currentAudience, linkPermissions, passwordProtected);
            if (url == null) {
                throw new IllegalArgumentException("Required value for 'url' is null");
            }
            this.url = url;
            this.audienceExceptions = null;
        }

        public Builder withAudienceExceptions(AudienceExceptions audienceExceptions) {
            this.audienceExceptions = audienceExceptions;
            return this;
        }

        @Override
        public Builder withAccessLevel(AccessLevel accessLevel) {
            super.withAccessLevel(accessLevel);
            return this;
        }

        @Override
        public Builder withAudienceRestrictingSharedFolder(AudienceRestrictingSharedFolder audienceRestrictingSharedFolder) {
            super.withAudienceRestrictingSharedFolder(audienceRestrictingSharedFolder);
            return this;
        }

        @Override
        public Builder withExpiry(Date expiry) {
            super.withExpiry(expiry);
            return this;
        }

        @Override
        public SharedContentLinkMetadata build() {
            return new SharedContentLinkMetadata(this.audienceOptions, this.currentAudience, this.linkPermissions, this.passwordProtected, this.url, this.accessLevel, this.audienceRestrictingSharedFolder, this.expiry, this.audienceExceptions);
        }
    }
}

