/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.paper;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.paper.Cursor;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class ListPaperDocsResponse {
    protected final List<String> docIds;
    protected final Cursor cursor;
    protected final boolean hasMore;

    public ListPaperDocsResponse(List<String> docIds, Cursor cursor, boolean hasMore) {
        if (docIds == null) {
            throw new IllegalArgumentException("Required value for 'docIds' is null");
        }
        for (String x : docIds) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list 'docIds' is null");
        }
        this.docIds = docIds;
        if (cursor == null) {
            throw new IllegalArgumentException("Required value for 'cursor' is null");
        }
        this.cursor = cursor;
        this.hasMore = hasMore;
    }

    public List<String> getDocIds() {
        return this.docIds;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public boolean getHasMore() {
        return this.hasMore;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.docIds, this.cursor, this.hasMore});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            ListPaperDocsResponse other = (ListPaperDocsResponse)obj;
            return !(this.docIds != other.docIds && !this.docIds.equals(other.docIds) || this.cursor != other.cursor && !this.cursor.equals(other.cursor) || this.hasMore != other.hasMore);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<ListPaperDocsResponse> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(ListPaperDocsResponse value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("doc_ids");
            StoneSerializers.list(StoneSerializers.string()).serialize(value.docIds, g2);
            g2.writeFieldName("cursor");
            Cursor.Serializer.INSTANCE.serialize(value.cursor, g2);
            g2.writeFieldName("has_more");
            StoneSerializers.boolean_().serialize((Boolean)value.hasMore, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public ListPaperDocsResponse deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_hasMore;
            Cursor f_cursor;
            List<String> f_docIds;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_docIds = null;
                f_cursor = null;
                f_hasMore = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("doc_ids".equals(field)) {
                        f_docIds = StoneSerializers.list(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("cursor".equals(field)) {
                        f_cursor = (Cursor)Cursor.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("has_more".equals(field)) {
                        f_hasMore = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_docIds == null) {
                    throw new JsonParseException(p, "Required field \"doc_ids\" missing.");
                }
                if (f_cursor == null) {
                    throw new JsonParseException(p, "Required field \"cursor\" missing.");
                }
                if (f_hasMore == null) {
                    throw new JsonParseException(p, "Required field \"has_more\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            ListPaperDocsResponse value = new ListPaperDocsResponse(f_docIds, f_cursor, f_hasMore);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

