/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.files;

import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.SaveUrlError;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public final class SaveUrlJobStatus {
    public static final SaveUrlJobStatus IN_PROGRESS = new SaveUrlJobStatus().withTag(Tag.IN_PROGRESS);
    private Tag _tag;
    private FileMetadata completeValue;
    private SaveUrlError failedValue;

    private SaveUrlJobStatus() {
    }

    private SaveUrlJobStatus withTag(Tag _tag) {
        SaveUrlJobStatus result = new SaveUrlJobStatus();
        result._tag = _tag;
        return result;
    }

    private SaveUrlJobStatus withTagAndComplete(Tag _tag, FileMetadata completeValue) {
        SaveUrlJobStatus result = new SaveUrlJobStatus();
        result._tag = _tag;
        result.completeValue = completeValue;
        return result;
    }

    private SaveUrlJobStatus withTagAndFailed(Tag _tag, SaveUrlError failedValue) {
        SaveUrlJobStatus result = new SaveUrlJobStatus();
        result._tag = _tag;
        result.failedValue = failedValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isInProgress() {
        return this._tag == Tag.IN_PROGRESS;
    }

    public boolean isComplete() {
        return this._tag == Tag.COMPLETE;
    }

    public static SaveUrlJobStatus complete(FileMetadata value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new SaveUrlJobStatus().withTagAndComplete(Tag.COMPLETE, value);
    }

    public FileMetadata getCompleteValue() {
        if (this._tag != Tag.COMPLETE) {
            throw new IllegalStateException("Invalid tag: required Tag.COMPLETE, but was Tag." + this._tag.name());
        }
        return this.completeValue;
    }

    public boolean isFailed() {
        return this._tag == Tag.FAILED;
    }

    public static SaveUrlJobStatus failed(SaveUrlError value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new SaveUrlJobStatus().withTagAndFailed(Tag.FAILED, value);
    }

    public SaveUrlError getFailedValue() {
        if (this._tag != Tag.FAILED) {
            throw new IllegalStateException("Invalid tag: required Tag.FAILED, but was Tag." + this._tag.name());
        }
        return this.failedValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.completeValue, this.failedValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof SaveUrlJobStatus) {
            SaveUrlJobStatus other = (SaveUrlJobStatus)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case IN_PROGRESS: {
                    return true;
                }
                case COMPLETE: {
                    return this.completeValue == other.completeValue || this.completeValue.equals(other.completeValue);
                }
                case FAILED: {
                    return this.failedValue == other.failedValue || this.failedValue.equals(other.failedValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<SaveUrlJobStatus> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(SaveUrlJobStatus value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case IN_PROGRESS: {
                    g2.writeString("in_progress");
                    break;
                }
                case COMPLETE: {
                    g2.writeStartObject();
                    this.writeTag("complete", g2);
                    FileMetadata.Serializer.INSTANCE.serialize(value.completeValue, g2, true);
                    g2.writeEndObject();
                    break;
                }
                case FAILED: {
                    g2.writeStartObject();
                    this.writeTag("failed", g2);
                    g2.writeFieldName("failed");
                    SaveUrlError.Serializer.INSTANCE.serialize(value.failedValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public SaveUrlJobStatus deserialize(JsonParser p) throws IOException, JsonParseException {
            SaveUrlJobStatus value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("in_progress".equals(tag)) {
                value = IN_PROGRESS;
            } else if ("complete".equals(tag)) {
                FileMetadata fieldValue = null;
                fieldValue = FileMetadata.Serializer.INSTANCE.deserialize(p, true);
                value = SaveUrlJobStatus.complete(fieldValue);
            } else if ("failed".equals(tag)) {
                SaveUrlError fieldValue = null;
                Serializer.expectField("failed", p);
                fieldValue = SaveUrlError.Serializer.INSTANCE.deserialize(p);
                value = SaveUrlJobStatus.failed(fieldValue);
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        IN_PROGRESS,
        COMPLETE,
        FAILED;

    }
}

