/*
 * Decompiled with CFR 0.152.
 */
package com.kantenkugel.discordbot.jdocparser;

import com.kantenkugel.discordbot.jdocparser.Documentation;
import com.kantenkugel.discordbot.jdocparser.JDocUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.apache.commons.collections4.OrderedMap;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class JDocParser {
    private static final int MAX_ENUM_FIELDS = 15;
    public static final Pattern METHOD_PATTERN = Pattern.compile("([a-zA-Z.<>?\\[\\]]+)\\s+([a-zA-Z][a-zA-Z0-9]+)\\(([@a-zA-Z0-9\\s.,<>?\\[\\]]*)\\)");
    public static final Pattern ANNOTATION_PATTERN = Pattern.compile("^((?:@[^\n]+\n)+)");
    public static final Pattern ANNOTATION_PARTS = Pattern.compile("@([a-zA-Z]+)(\\((\"?).*?\\3\\))?\n");
    public static final Pattern METHOD_ARG_PATTERN = Pattern.compile("(?:[a-z]+\\.)*([a-zA-Z][a-zA-Z0-9.<,?>\\[\\]]*)\\s+([a-zA-Z][a-zA-Z0-9]*)(?:\\s*,|$)");
    static final String SUBCLASSES_MAP_KEY = "#JDOC_SUBCLASSES_KEY#";

    static Map<String, ClassDocumentation> parse() {
        JDocUtil.LOG.debug("Parsing jda-docs-files");
        HashMap<String, ClassDocumentation> docs = new HashMap<String, ClassDocumentation>();
        try (JarFile file = new JarFile(JDocUtil.LOCAL_DOC_PATH.toFile());){
            file.stream().filter(entry -> !entry.isDirectory() && entry.getName().startsWith("net/dv8tion/jda") && entry.getName().endsWith(".html")).forEach(entry -> {
                try {
                    JDocParser.parse(JDocUtil.JDOCBASE, entry.getName(), file.getInputStream((ZipEntry)entry), docs);
                }
                catch (IOException e) {
                    JDocUtil.LOG.error("Error while parsing doc file {}", (Object)entry.getName(), (Object)e);
                }
            });
            ClassDocumentation subClassesNode = (ClassDocumentation)docs.remove(SUBCLASSES_MAP_KEY);
            if (subClassesNode != null) {
                subClassesNode.subClasses.forEach((subclassName, subClassDoc) -> {
                    if (subClassDoc.classSig != null && !docs.containsKey(subclassName)) {
                        docs.put((String)subclassName, (ClassDocumentation)subClassDoc);
                    }
                });
            }
            JDocUtil.LOG.debug("Done parsing jda-docs-files");
        }
        catch (Exception e) {
            JDocUtil.LOG.error("Error reading the jdoc jarfile", e);
        }
        return docs;
    }

    private static Element getSingleElementByClass(Element root, String className) {
        Elements elementsByClass = root.getElementsByClass(className);
        if (elementsByClass.size() != 1) {
            String error = "Found " + elementsByClass.size() + " elements with class " + className + " inside of " + root.tagName() + "-" + root.className();
            throw new RuntimeException(error + root.html());
        }
        return elementsByClass.first();
    }

    private static Element getSingleElementByQuery(Element root, String query) {
        Elements elementsByQuery = root.select(query);
        if (elementsByQuery.size() > 1) {
            String error = "Found " + elementsByQuery.size() + " elements matching query \"" + query + "\" inside of " + root.tagName() + "-" + root.className();
            throw new RuntimeException(error + root.html());
        }
        return elementsByQuery.first();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void parse(String jdocBase, String name, InputStream inputStream, Map<String, ClassDocumentation> docs) {
        String[] pathSplits = name.split("/");
        String fileName = pathSplits[pathSplits.length - 1];
        if (!Character.isUpperCase(fileName.charAt(0))) {
            return;
        }
        String[] nameSplits = fileName.split("\\.");
        String className = nameSplits[nameSplits.length - 2];
        String fullName = fileName.substring(0, fileName.length() - nameSplits[nameSplits.length - 1].length() - 1);
        try (BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream));){
            String content = buffer.lines().collect(Collectors.joining("\n"));
            Document document = Jsoup.parse(content);
            Element titleElem = JDocParser.getSingleElementByClass(document, "title");
            String classSig = JDocUtil.fixSpaces(titleElem.text());
            Element packageElem = titleElem.previousElementSibling();
            if (packageElem.children().size() > 1) {
                packageElem = packageElem.children().last();
            }
            String pack = JDocUtil.fixSpaces(packageElem.text());
            String link = JDocUtil.getLink(jdocBase, pack, fullName);
            Element descriptionElement = null;
            Elements descriptionCandidates = document.select(".description .block");
            if (descriptionCandidates.size() > 1) {
                List removed = descriptionCandidates.stream().map(elem -> elem.child(0)).filter(child -> child != null && !child.className().startsWith("deprecat")).map(Element::parent).collect(Collectors.toList());
                if (removed.size() != 1) {
                    throw new RuntimeException("Found too many description candidates");
                }
                descriptionElement = (Element)removed.get(0);
            } else if (descriptionCandidates.size() == 1) {
                descriptionElement = (Element)descriptionCandidates.get(0);
            }
            String description = descriptionElement == null ? "" : JDocUtil.formatText(descriptionElement.html(), link);
            ClassDocumentation classDoc = new ClassDocumentation(pack, fullName, classSig, description, classSig.startsWith("Enum"));
            Element details = document.getElementsByClass("details").first();
            if (details != null) {
                Element tmp = JDocParser.getSingleElementByQuery(details, "a[name=\"method.detail\"], a[id=\"method.detail\"]");
                List<DocBlock> docBlock = JDocParser.getDocBlock(jdocBase, tmp, classDoc);
                if (docBlock != null) {
                    for (DocBlock block : docBlock) {
                        Set mdocs = classDoc.methodDocs.computeIfAbsent(block.title.toLowerCase(), key -> new HashSet());
                        mdocs.add(new MethodDocumentation(classDoc, block.signature, block.hashLink, block.description, block.fields));
                    }
                }
                if ((docBlock = JDocParser.getDocBlock(jdocBase, tmp = JDocParser.getSingleElementByQuery(details, "a[name=\"field.detail\"], a[id=\"field.detail\"]"), classDoc)) != null) {
                    for (DocBlock block : docBlock) {
                        classDoc.classValues.put(block.title.toLowerCase(), new ValueDocumentation(classDoc, block.title, block.hashLink, block.signature, block.description));
                    }
                }
                if ((docBlock = JDocParser.getDocBlock(jdocBase, tmp = JDocParser.getSingleElementByQuery(details, "a[name=\"enum.constant.detail\"], a[id=\"enum.constant.detail\"]"), classDoc)) != null) {
                    for (DocBlock block : docBlock) {
                        classDoc.classValues.put(block.title.toLowerCase(), new ValueDocumentation(classDoc, block.title, block.hashLink, block.signature, block.description));
                    }
                }
            }
            Element methodSummary = JDocParser.getSingleElementByQuery(document, "a[name=\"method.summary\"], a[id=\"method.summary\"]");
            classDoc.inheritedMethods.putAll(JDocParser.getInheritedMethods(methodSummary));
            if (nameSplits.length > 2) {
                ClassDocumentation parent = docs.computeIfAbsent(nameSplits[0].toLowerCase(), key -> new ClassDocumentation(null, null, null, null, false));
                for (int i = 1; i < nameSplits.length - 2; ++i) {
                    parent = parent.subClasses.computeIfAbsent(nameSplits[i].toLowerCase(), key -> new ClassDocumentation(null, null, null, null, false));
                }
                if (parent.subClasses.containsKey(className.toLowerCase())) {
                    classDoc.subClasses.putAll(parent.subClasses.get((Object)className.toLowerCase()).subClasses);
                }
                parent.subClasses.put(className.toLowerCase(), classDoc);
                String actualClassName = nameSplits[nameSplits.length - 2].toLowerCase();
                ClassDocumentation subClassesNode = docs.computeIfAbsent(SUBCLASSES_MAP_KEY, key -> new ClassDocumentation(null, null, null, null, false));
                ClassDocumentation subClassElem = subClassesNode.subClasses.get(actualClassName);
                if (subClassElem != null && subClassElem.classSig != null) {
                    subClassesNode.subClasses.put(actualClassName, new ClassDocumentation(null, null, null, null, false));
                } else if (subClassElem == null) {
                    subClassesNode.subClasses.put(actualClassName, classDoc);
                }
            } else {
                ClassDocumentation current = docs.get(className.toLowerCase());
                if (current != null && current.classSig != null) {
                    throw new RuntimeException(String.format("Got a class-name conflict with classes %s.%s AND %s.%s", classDoc.pack, classDoc.className, current.pack, current.className));
                }
                if (current != null) {
                    classDoc.subClasses.putAll(current.subClasses);
                }
                docs.put(className.toLowerCase(), classDoc);
            }
        }
        catch (IOException | NullPointerException ex) {
            JDocUtil.LOG.error("Got excaption for element {}", (Object)fullName, (Object)ex);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                JDocUtil.LOG.error("Error closing inputstream", e);
            }
        }
    }

    private static Map<String, String> getInheritedMethods(Element summaryAnchor) {
        HashMap<String, String> inherited = new HashMap<String, String>();
        if (summaryAnchor == null) {
            return inherited;
        }
        summaryAnchor = summaryAnchor.parent();
        Elements inheritAnchors = summaryAnchor.select("a[name^=\"methods.inherited.from.class\"], a[id^=\"methods.inherited.from.class\"]");
        for (Element inheritAnchor : inheritAnchors) {
            if (inheritAnchor.siblingElements().size() != 2) continue;
            Element next = inheritAnchor.nextElementSibling();
            if (!next.tagName().equals("h3")) {
                throw new RuntimeException("Got unexpected html while parsing inherited methods from class " + inheritAnchor.attr("name"));
            }
            Element sub = next.children().last();
            if (sub == null || !sub.tagName().equals("a")) continue;
            String parent = sub.text().toLowerCase();
            if (!(next = next.nextElementSibling()).tagName().equals("code")) {
                throw new RuntimeException("Got unexpected html while parsing inherited methods from class " + inheritAnchor.attr("name"));
            }
            for (sub = next.children().first(); sub != null; sub = sub.nextElementSibling()) {
                if (!sub.tagName().equals("a")) continue;
                inherited.putIfAbsent(sub.text().toLowerCase(), parent);
            }
        }
        return inherited;
    }

    private static List<DocBlock> getDocBlock(String jdocBase, Element elem, ClassDocumentation reference) {
        if (elem != null) {
            String baseLink = JDocUtil.getLink(jdocBase, reference);
            ArrayList<DocBlock> blocks = new ArrayList<DocBlock>(10);
            String hashLink = null;
            for (elem = elem.nextElementSibling(); elem != null; elem = elem.nextElementSibling()) {
                if (elem.tagName().equals("a")) {
                    hashLink = '#' + (elem.id().isEmpty() ? elem.attr("name") : elem.id());
                    continue;
                }
                if (!elem.tagName().equals("ul")) continue;
                Element tmp = elem.getElementsByTag("h4").first();
                String title = JDocUtil.fixSpaces(tmp.text().trim());
                String description = "";
                String signature = "";
                ListOrderedMap<String, List<String>> fields = new ListOrderedMap<String, List<String>>();
                for (tmp = tmp.nextElementSibling(); tmp != null; tmp = tmp.nextElementSibling()) {
                    Element deprecationElem;
                    if (tmp.tagName().equals("pre")) {
                        signature = JDocUtil.fixSpaces(tmp.text().trim());
                        continue;
                    }
                    if (tmp.tagName().equals("div") && tmp.className().equals("deprecationBlock")) {
                        deprecationElem = tmp.getElementsByClass("deprecationComment").first();
                        if (deprecationElem == null) continue;
                        fields.put("Deprecated:", Collections.singletonList(JDocUtil.formatText(deprecationElem.html(), baseLink)));
                        continue;
                    }
                    if (tmp.tagName().equals("div") && tmp.className().equals("block")) {
                        deprecationElem = tmp.getElementsByClass("deprecationComment").first();
                        if (deprecationElem != null) {
                            fields.put("Deprecated:", Collections.singletonList(JDocUtil.formatText(deprecationElem.html(), baseLink)));
                            continue;
                        }
                        description = JDocUtil.formatText(tmp.html(), baseLink);
                        continue;
                    }
                    if (!tmp.tagName().equals("dl")) continue;
                    String fieldName = null;
                    ArrayList<String> fieldValues = new ArrayList<String>();
                    for (Element element : tmp.children()) {
                        if (element.tagName().equals("dt")) {
                            if (fieldName != null) {
                                fields.put(fieldName, fieldValues);
                                fieldValues = new ArrayList();
                            }
                            fieldName = JDocUtil.fixSpaces(element.text().trim());
                            continue;
                        }
                        if (!element.tagName().equals("dd")) continue;
                        fieldValues.add(JDocUtil.formatText(element.html(), baseLink));
                    }
                    if (fieldName == null) continue;
                    fields.put(fieldName, fieldValues);
                }
                blocks.add(new DocBlock(title, hashLink, signature, description, fields));
            }
            return blocks;
        }
        return null;
    }

    static class ValueDocumentation
    implements Documentation {
        final ClassDocumentation parent;
        final String name;
        final String hashLink;
        final String sig;
        final String desc;

        private ValueDocumentation(ClassDocumentation parent, String name, String hashLink, String sig, String desc) {
            this.parent = parent;
            this.name = name;
            this.hashLink = hashLink;
            this.sig = sig;
            this.desc = desc;
        }

        @Override
        public String getTitle() {
            return this.parent.isEnum ? this.getShortTitle() : this.parent.className + " - " + this.sig;
        }

        @Override
        public String getShortTitle() {
            return this.parent.className + '.' + this.name;
        }

        @Override
        public String getUrl(String jDocBase) {
            return JDocUtil.getLink(jDocBase, this.parent) + this.hashLink;
        }

        @Override
        public String getContent() {
            return this.desc;
        }
    }

    static class MethodDocumentation
    implements Documentation {
        final ClassDocumentation parent;
        final List<MethodAnnotation> methodAnnos;
        final String returnType;
        final String functionName;
        final String parameters;
        final String functionSig;
        final List<String> argTypes;
        final String hashLink;
        final String desc;
        final OrderedMap<String, List<String>> fields;

        protected MethodDocumentation(ClassDocumentation parent, String functionSig, String hashLink, String desc, OrderedMap<String, List<String>> fields) {
            Matcher methodMatcher;
            String noAnnoSig = functionSig = JDocUtil.fixSignature(functionSig);
            this.methodAnnos = new ArrayList<MethodAnnotation>();
            Matcher annoGroupMatcher = ANNOTATION_PATTERN.matcher(functionSig);
            if (annoGroupMatcher.find()) {
                noAnnoSig = annoGroupMatcher.replaceFirst("");
                Matcher annoMatcher = ANNOTATION_PARTS.matcher(annoGroupMatcher.group(1));
                while (annoMatcher.find()) {
                    this.methodAnnos.add(new MethodAnnotation(annoMatcher.group(1), annoMatcher.group(2)));
                }
            }
            if (!(methodMatcher = METHOD_PATTERN.matcher(noAnnoSig)).find()) {
                System.out.println('\"' + functionSig + '\"');
                throw new RuntimeException("Got method with no proper method signature: " + functionSig);
            }
            this.parent = parent;
            this.returnType = methodMatcher.group(1);
            this.functionName = methodMatcher.group(2);
            this.parameters = methodMatcher.group(3);
            this.functionSig = methodMatcher.group();
            this.hashLink = hashLink;
            this.desc = desc;
            this.fields = fields;
            String args = methodMatcher.group(3);
            Matcher argMatcher = METHOD_ARG_PATTERN.matcher(args);
            this.argTypes = new ArrayList<String>(3);
            while (argMatcher.find()) {
                this.argTypes.add(argMatcher.group(1).toLowerCase().split("<")[0]);
            }
            if (!args.isEmpty() && this.argTypes.size() == 0) {
                throw new RuntimeException("Got non-empty parameters for method " + this.functionName + " but couldn't parse them. Signature: \"" + functionSig + '\"');
            }
        }

        boolean matches(String input, boolean fuzzy) {
            int argLength;
            Matcher matcher = METHOD_PATTERN.matcher("ff " + input);
            if (!matcher.find()) {
                return false;
            }
            if (!matcher.group(2).equalsIgnoreCase(this.functionName)) {
                return false;
            }
            if (fuzzy) {
                return true;
            }
            String args = matcher.group(3);
            String[] split = args.toLowerCase().split(",");
            int n = argLength = args.trim().isEmpty() ? 0 : split.length;
            if (argLength != this.argTypes.size()) {
                return false;
            }
            for (int i = 0; i < this.argTypes.size(); ++i) {
                if (split[i].trim().equals(this.argTypes.get(i))) continue;
                return false;
            }
            return true;
        }

        @Override
        public String getShortTitle() {
            return this.parent.className + '#' + this.functionName + '(' + this.parameters + ") : " + this.returnType;
        }

        @Override
        public String getTitle() {
            return this.getAnnoPrefix() + "\n" + this.getShortTitle();
        }

        @Override
        public String getUrl(String jdocBase) {
            return JDocUtil.fixUrl(JDocUtil.getLink(jdocBase, this.parent) + this.hashLink);
        }

        @Override
        public String getContent() {
            return this.desc;
        }

        @Override
        public Map<String, List<String>> getFields() {
            return this.fields;
        }

        private String getAnnoPrefix() {
            if (this.methodAnnos.isEmpty()) {
                return "";
            }
            boolean deprecated = false;
            String deprecatedSince = null;
            StringBuilder builder = new StringBuilder();
            block8: for (MethodAnnotation methodAnno : this.methodAnnos) {
                switch (methodAnno.name) {
                    case "Deprecated": {
                        deprecated = true;
                        continue block8;
                    }
                    case "DeprecatedSince": {
                        deprecatedSince = methodAnno.args.substring(2, methodAnno.args.length() - 2);
                        continue block8;
                    }
                }
                builder.append('@').append(methodAnno.toString()).append(' ');
            }
            if (deprecated || deprecatedSince != null) {
                StringBuilder tmp = new StringBuilder("@Deprecated");
                if (deprecatedSince != null) {
                    tmp.append("(Since ").append(deprecatedSince).append(") ");
                }
                builder = tmp.append((CharSequence)builder);
            }
            return builder.substring(0, builder.length() - 1);
        }

        private static class MethodAnnotation {
            private final String name;
            private final String args;

            private MethodAnnotation(String name, String args) {
                this.name = name;
                this.args = args;
            }

            public String toString() {
                return this.name + (this.args == null ? "" : this.args);
            }
        }
    }

    static class ClassDocumentation
    implements Documentation {
        final String pack;
        final String className;
        final String classSig;
        final String classDesc;
        final boolean isEnum;
        final Map<String, Set<MethodDocumentation>> methodDocs = new HashMap<String, Set<MethodDocumentation>>();
        final Map<String, ClassDocumentation> subClasses = new HashMap<String, ClassDocumentation>();
        final Map<String, ValueDocumentation> classValues = new HashMap<String, ValueDocumentation>();
        final Map<String, String> inheritedMethods = new HashMap<String, String>();

        private ClassDocumentation(String pack, String className, String classSig, String classDesc, boolean isEnum) {
            this.pack = pack;
            this.className = className;
            this.classSig = classSig;
            this.classDesc = classDesc;
            this.isEnum = isEnum;
        }

        @Override
        public String getTitle() {
            return this.getShortTitle();
        }

        @Override
        public String getShortTitle() {
            return this.classSig;
        }

        @Override
        public String getUrl(String jdocBase) {
            return JDocUtil.getLink(jdocBase, this);
        }

        @Override
        public String getContent() {
            return this.classDesc;
        }

        @Override
        public Map<String, List<String>> getFields() {
            if (!this.isEnum) {
                return null;
            }
            HashMap<String, List<String>> fields = new HashMap<String, List<String>>();
            List fieldNames = this.classValues.values().stream().limit(15L).map(valueDoc -> valueDoc.name).collect(Collectors.toList());
            if (this.classValues.size() > 15) {
                fieldNames.add("... and more ...");
            }
            fields.put("Values:", fieldNames);
            return fields;
        }
    }

    private static class DocBlock {
        private final String title;
        private final String hashLink;
        private final String signature;
        private final String description;
        private final OrderedMap<String, List<String>> fields;

        private DocBlock(String title, String hashLink, String signature, String description, OrderedMap<String, List<String>> fields) {
            this.title = title;
            this.hashLink = hashLink;
            this.signature = signature;
            this.description = description;
            this.fields = fields;
        }
    }
}

