/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamlog.FileRequestDetails;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public class FileRequestDeleteDetails {
    protected final String fileRequestId;
    protected final FileRequestDetails previousDetails;

    public FileRequestDeleteDetails(String fileRequestId, FileRequestDetails previousDetails) {
        if (fileRequestId != null) {
            if (fileRequestId.length() < 1) {
                throw new IllegalArgumentException("String 'fileRequestId' is shorter than 1");
            }
            if (!Pattern.matches("[-_0-9a-zA-Z]+", fileRequestId)) {
                throw new IllegalArgumentException("String 'fileRequestId' does not match pattern");
            }
        }
        this.fileRequestId = fileRequestId;
        this.previousDetails = previousDetails;
    }

    public FileRequestDeleteDetails() {
        this(null, null);
    }

    public String getFileRequestId() {
        return this.fileRequestId;
    }

    public FileRequestDetails getPreviousDetails() {
        return this.previousDetails;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.fileRequestId, this.previousDetails});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            FileRequestDeleteDetails other = (FileRequestDeleteDetails)obj;
            return (this.fileRequestId == other.fileRequestId || this.fileRequestId != null && this.fileRequestId.equals(other.fileRequestId)) && (this.previousDetails == other.previousDetails || this.previousDetails != null && this.previousDetails.equals(other.previousDetails));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<FileRequestDeleteDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(FileRequestDeleteDetails value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            if (value.fileRequestId != null) {
                g2.writeFieldName("file_request_id");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.fileRequestId, g2);
            }
            if (value.previousDetails != null) {
                g2.writeFieldName("previous_details");
                StoneSerializers.nullableStruct(FileRequestDetails.Serializer.INSTANCE).serialize(value.previousDetails, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public FileRequestDeleteDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            FileRequestDetails f_previousDetails;
            String f_fileRequestId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_fileRequestId = null;
                f_previousDetails = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("file_request_id".equals(field)) {
                        f_fileRequestId = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("previous_details".equals(field)) {
                        f_previousDetails = StoneSerializers.nullableStruct(FileRequestDetails.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            FileRequestDeleteDetails value = new FileRequestDeleteDetails(f_fileRequestId, f_previousDetails);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected String fileRequestId = null;
        protected FileRequestDetails previousDetails = null;

        protected Builder() {
        }

        public Builder withFileRequestId(String fileRequestId) {
            if (fileRequestId != null) {
                if (fileRequestId.length() < 1) {
                    throw new IllegalArgumentException("String 'fileRequestId' is shorter than 1");
                }
                if (!Pattern.matches("[-_0-9a-zA-Z]+", fileRequestId)) {
                    throw new IllegalArgumentException("String 'fileRequestId' does not match pattern");
                }
            }
            this.fileRequestId = fileRequestId;
            return this;
        }

        public Builder withPreviousDetails(FileRequestDetails previousDetails) {
            this.previousDetails = previousDetails;
            return this;
        }

        public FileRequestDeleteDetails build() {
            return new FileRequestDeleteDetails(this.fileRequestId, this.previousDetails);
        }
    }
}

