/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.fileproperties;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public final class ModifyTemplateError {
    public static final ModifyTemplateError RESTRICTED_CONTENT = new ModifyTemplateError().withTag(Tag.RESTRICTED_CONTENT);
    public static final ModifyTemplateError OTHER = new ModifyTemplateError().withTag(Tag.OTHER);
    public static final ModifyTemplateError CONFLICTING_PROPERTY_NAMES = new ModifyTemplateError().withTag(Tag.CONFLICTING_PROPERTY_NAMES);
    public static final ModifyTemplateError TOO_MANY_PROPERTIES = new ModifyTemplateError().withTag(Tag.TOO_MANY_PROPERTIES);
    public static final ModifyTemplateError TOO_MANY_TEMPLATES = new ModifyTemplateError().withTag(Tag.TOO_MANY_TEMPLATES);
    public static final ModifyTemplateError TEMPLATE_ATTRIBUTE_TOO_LARGE = new ModifyTemplateError().withTag(Tag.TEMPLATE_ATTRIBUTE_TOO_LARGE);
    private Tag _tag;
    private String templateNotFoundValue;

    private ModifyTemplateError() {
    }

    private ModifyTemplateError withTag(Tag _tag) {
        ModifyTemplateError result = new ModifyTemplateError();
        result._tag = _tag;
        return result;
    }

    private ModifyTemplateError withTagAndTemplateNotFound(Tag _tag, String templateNotFoundValue) {
        ModifyTemplateError result = new ModifyTemplateError();
        result._tag = _tag;
        result.templateNotFoundValue = templateNotFoundValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isTemplateNotFound() {
        return this._tag == Tag.TEMPLATE_NOT_FOUND;
    }

    public static ModifyTemplateError templateNotFound(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() < 1) {
            throw new IllegalArgumentException("String is shorter than 1");
        }
        if (!Pattern.matches("(/|ptid:).*", value)) {
            throw new IllegalArgumentException("String does not match pattern");
        }
        return new ModifyTemplateError().withTagAndTemplateNotFound(Tag.TEMPLATE_NOT_FOUND, value);
    }

    public String getTemplateNotFoundValue() {
        if (this._tag != Tag.TEMPLATE_NOT_FOUND) {
            throw new IllegalStateException("Invalid tag: required Tag.TEMPLATE_NOT_FOUND, but was Tag." + this._tag.name());
        }
        return this.templateNotFoundValue;
    }

    public boolean isRestrictedContent() {
        return this._tag == Tag.RESTRICTED_CONTENT;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public boolean isConflictingPropertyNames() {
        return this._tag == Tag.CONFLICTING_PROPERTY_NAMES;
    }

    public boolean isTooManyProperties() {
        return this._tag == Tag.TOO_MANY_PROPERTIES;
    }

    public boolean isTooManyTemplates() {
        return this._tag == Tag.TOO_MANY_TEMPLATES;
    }

    public boolean isTemplateAttributeTooLarge() {
        return this._tag == Tag.TEMPLATE_ATTRIBUTE_TOO_LARGE;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.templateNotFoundValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ModifyTemplateError) {
            ModifyTemplateError other = (ModifyTemplateError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case TEMPLATE_NOT_FOUND: {
                    return this.templateNotFoundValue == other.templateNotFoundValue || this.templateNotFoundValue.equals(other.templateNotFoundValue);
                }
                case RESTRICTED_CONTENT: {
                    return true;
                }
                case OTHER: {
                    return true;
                }
                case CONFLICTING_PROPERTY_NAMES: {
                    return true;
                }
                case TOO_MANY_PROPERTIES: {
                    return true;
                }
                case TOO_MANY_TEMPLATES: {
                    return true;
                }
                case TEMPLATE_ATTRIBUTE_TOO_LARGE: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    public static class Serializer
    extends UnionSerializer<ModifyTemplateError> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public void serialize(ModifyTemplateError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case TEMPLATE_NOT_FOUND: {
                    g2.writeStartObject();
                    this.writeTag("template_not_found", g2);
                    g2.writeFieldName("template_not_found");
                    StoneSerializers.string().serialize(value.templateNotFoundValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case RESTRICTED_CONTENT: {
                    g2.writeString("restricted_content");
                    break;
                }
                case OTHER: {
                    g2.writeString("other");
                    break;
                }
                case CONFLICTING_PROPERTY_NAMES: {
                    g2.writeString("conflicting_property_names");
                    break;
                }
                case TOO_MANY_PROPERTIES: {
                    g2.writeString("too_many_properties");
                    break;
                }
                case TOO_MANY_TEMPLATES: {
                    g2.writeString("too_many_templates");
                    break;
                }
                case TEMPLATE_ATTRIBUTE_TOO_LARGE: {
                    g2.writeString("template_attribute_too_large");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public ModifyTemplateError deserialize(JsonParser p) throws IOException, JsonParseException {
            ModifyTemplateError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("template_not_found".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("template_not_found", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = ModifyTemplateError.templateNotFound(fieldValue);
            } else if ("restricted_content".equals(tag)) {
                value = RESTRICTED_CONTENT;
            } else if ("other".equals(tag)) {
                value = OTHER;
            } else if ("conflicting_property_names".equals(tag)) {
                value = CONFLICTING_PROPERTY_NAMES;
            } else if ("too_many_properties".equals(tag)) {
                value = TOO_MANY_PROPERTIES;
            } else if ("too_many_templates".equals(tag)) {
                value = TOO_MANY_TEMPLATES;
            } else if ("template_attribute_too_large".equals(tag)) {
                value = TEMPLATE_ATTRIBUTE_TOO_LARGE;
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        TEMPLATE_NOT_FOUND,
        RESTRICTED_CONTENT,
        OTHER,
        CONFLICTING_PROPERTY_NAMES,
        TOO_MANY_PROPERTIES,
        TOO_MANY_TEMPLATES,
        TEMPLATE_ATTRIBUTE_TOO_LARGE;

    }
}

