/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class TeamName {
    protected final String teamDisplayName;
    protected final String teamLegalName;

    public TeamName(String teamDisplayName, String teamLegalName) {
        if (teamDisplayName == null) {
            throw new IllegalArgumentException("Required value for 'teamDisplayName' is null");
        }
        this.teamDisplayName = teamDisplayName;
        if (teamLegalName == null) {
            throw new IllegalArgumentException("Required value for 'teamLegalName' is null");
        }
        this.teamLegalName = teamLegalName;
    }

    public String getTeamDisplayName() {
        return this.teamDisplayName;
    }

    public String getTeamLegalName() {
        return this.teamLegalName;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.teamDisplayName, this.teamLegalName});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamName other = (TeamName)obj;
            return !(this.teamDisplayName != other.teamDisplayName && !this.teamDisplayName.equals(other.teamDisplayName) || this.teamLegalName != other.teamLegalName && !this.teamLegalName.equals(other.teamLegalName));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TeamName> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamName value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("team_display_name");
            StoneSerializers.string().serialize(value.teamDisplayName, g2);
            g2.writeFieldName("team_legal_name");
            StoneSerializers.string().serialize(value.teamLegalName, g2);
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public TeamName deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_teamLegalName;
            String f_teamDisplayName;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_teamDisplayName = null;
                f_teamLegalName = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("team_display_name".equals(field)) {
                        f_teamDisplayName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("team_legal_name".equals(field)) {
                        f_teamLegalName = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_teamDisplayName == null) {
                    throw new JsonParseException(p, "Required field \"team_display_name\" missing.");
                }
                if (f_teamLegalName == null) {
                    throw new JsonParseException(p, "Required field \"team_legal_name\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TeamName value = new TeamName(f_teamDisplayName, f_teamLegalName);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }
}

