/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public final class GetTeamEventsContinueError {
    public static final GetTeamEventsContinueError BAD_CURSOR = new GetTeamEventsContinueError().withTag(Tag.BAD_CURSOR);
    public static final GetTeamEventsContinueError OTHER = new GetTeamEventsContinueError().withTag(Tag.OTHER);
    private Tag _tag;
    private Date resetValue;

    private GetTeamEventsContinueError() {
    }

    private GetTeamEventsContinueError withTag(Tag _tag) {
        GetTeamEventsContinueError result = new GetTeamEventsContinueError();
        result._tag = _tag;
        return result;
    }

    private GetTeamEventsContinueError withTagAndReset(Tag _tag, Date resetValue) {
        GetTeamEventsContinueError result = new GetTeamEventsContinueError();
        result._tag = _tag;
        result.resetValue = resetValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isBadCursor() {
        return this._tag == Tag.BAD_CURSOR;
    }

    public boolean isReset() {
        return this._tag == Tag.RESET;
    }

    public static GetTeamEventsContinueError reset(Date value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        return new GetTeamEventsContinueError().withTagAndReset(Tag.RESET, value);
    }

    public Date getResetValue() {
        if (this._tag != Tag.RESET) {
            throw new IllegalStateException("Invalid tag: required Tag.RESET, but was Tag." + this._tag.name());
        }
        return this.resetValue;
    }

    public boolean isOther() {
        return this._tag == Tag.OTHER;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.resetValue});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof GetTeamEventsContinueError) {
            GetTeamEventsContinueError other = (GetTeamEventsContinueError)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case BAD_CURSOR: {
                    return true;
                }
                case RESET: {
                    return this.resetValue == other.resetValue || this.resetValue.equals(other.resetValue);
                }
                case OTHER: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<GetTeamEventsContinueError> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(GetTeamEventsContinueError value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case BAD_CURSOR: {
                    g2.writeString("bad_cursor");
                    break;
                }
                case RESET: {
                    g2.writeStartObject();
                    this.writeTag("reset", g2);
                    g2.writeFieldName("reset");
                    StoneSerializers.timestamp().serialize(value.resetValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    g2.writeString("other");
                }
            }
        }

        @Override
        public GetTeamEventsContinueError deserialize(JsonParser p) throws IOException, JsonParseException {
            GetTeamEventsContinueError value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("bad_cursor".equals(tag)) {
                value = BAD_CURSOR;
            } else if ("reset".equals(tag)) {
                Date fieldValue = null;
                Serializer.expectField("reset", p);
                fieldValue = StoneSerializers.timestamp().deserialize(p);
                value = GetTeamEventsContinueError.reset(fieldValue);
            } else {
                value = OTHER;
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        BAD_CURSOR,
        RESET,
        OTHER;

    }
}

