/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.teamlog;

import com.dropbox.core.stone.StoneDeserializerLogger;
import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.teamlog.SessionLogInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;

public class DeviceDeleteOnUnlinkFailDetails {
    protected final SessionLogInfo sessionInfo;
    protected final String displayName;
    protected final long numFailures;

    public DeviceDeleteOnUnlinkFailDetails(long numFailures, SessionLogInfo sessionInfo, String displayName) {
        this.sessionInfo = sessionInfo;
        this.displayName = displayName;
        this.numFailures = numFailures;
    }

    public DeviceDeleteOnUnlinkFailDetails(long numFailures) {
        this(numFailures, null, null);
    }

    public long getNumFailures() {
        return this.numFailures;
    }

    public SessionLogInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static Builder newBuilder(long numFailures) {
        return new Builder(numFailures);
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.sessionInfo, this.displayName, this.numFailures});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            DeviceDeleteOnUnlinkFailDetails other = (DeviceDeleteOnUnlinkFailDetails)obj;
            return this.numFailures == other.numFailures && (this.sessionInfo == other.sessionInfo || this.sessionInfo != null && this.sessionInfo.equals(other.sessionInfo)) && (this.displayName == other.displayName || this.displayName != null && this.displayName.equals(other.displayName));
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<DeviceDeleteOnUnlinkFailDetails> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(DeviceDeleteOnUnlinkFailDetails value, JsonGenerator g2, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g2.writeStartObject();
            }
            g2.writeFieldName("num_failures");
            StoneSerializers.int64().serialize((Long)value.numFailures, g2);
            if (value.sessionInfo != null) {
                g2.writeFieldName("session_info");
                StoneSerializers.nullableStruct(SessionLogInfo.Serializer.INSTANCE).serialize(value.sessionInfo, g2);
            }
            if (value.displayName != null) {
                g2.writeFieldName("display_name");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.displayName, g2);
            }
            if (!collapse) {
                g2.writeEndObject();
            }
        }

        @Override
        public DeviceDeleteOnUnlinkFailDetails deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            String f_displayName;
            SessionLogInfo f_sessionInfo;
            Long f_numFailures;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_numFailures = null;
                f_sessionInfo = null;
                f_displayName = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("num_failures".equals(field)) {
                        f_numFailures = StoneSerializers.int64().deserialize(p);
                        continue;
                    }
                    if ("session_info".equals(field)) {
                        f_sessionInfo = StoneSerializers.nullableStruct(SessionLogInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    if ("display_name".equals(field)) {
                        f_displayName = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_numFailures == null) {
                    throw new JsonParseException(p, "Required field \"num_failures\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            DeviceDeleteOnUnlinkFailDetails value = new DeviceDeleteOnUnlinkFailDetails(f_numFailures, f_sessionInfo, f_displayName);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            StoneDeserializerLogger.log(value, value.toStringMultiline());
            return value;
        }
    }

    public static class Builder {
        protected final long numFailures;
        protected SessionLogInfo sessionInfo;
        protected String displayName;

        protected Builder(long numFailures) {
            this.numFailures = numFailures;
            this.sessionInfo = null;
            this.displayName = null;
        }

        public Builder withSessionInfo(SessionLogInfo sessionInfo) {
            this.sessionInfo = sessionInfo;
            return this;
        }

        public Builder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public DeviceDeleteOnUnlinkFailDetails build() {
            return new DeviceDeleteOnUnlinkFailDetails(this.numFailures, this.sessionInfo, this.displayName);
        }
    }
}

