/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.UnionSerializer;
import com.dropbox.core.v2.team.MemberAddResult;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public final class MembersAddLaunch {
    private Tag _tag;
    private String asyncJobIdValue;
    private List<MemberAddResult> completeValue;

    private MembersAddLaunch() {
    }

    private MembersAddLaunch withTag(Tag _tag) {
        MembersAddLaunch result = new MembersAddLaunch();
        result._tag = _tag;
        return result;
    }

    private MembersAddLaunch withTagAndAsyncJobId(Tag _tag, String asyncJobIdValue) {
        MembersAddLaunch result = new MembersAddLaunch();
        result._tag = _tag;
        result.asyncJobIdValue = asyncJobIdValue;
        return result;
    }

    private MembersAddLaunch withTagAndComplete(Tag _tag, List<MemberAddResult> completeValue) {
        MembersAddLaunch result = new MembersAddLaunch();
        result._tag = _tag;
        result.completeValue = completeValue;
        return result;
    }

    public Tag tag() {
        return this._tag;
    }

    public boolean isAsyncJobId() {
        return this._tag == Tag.ASYNC_JOB_ID;
    }

    public static MembersAddLaunch asyncJobId(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        if (value.length() < 1) {
            throw new IllegalArgumentException("String is shorter than 1");
        }
        return new MembersAddLaunch().withTagAndAsyncJobId(Tag.ASYNC_JOB_ID, value);
    }

    public String getAsyncJobIdValue() {
        if (this._tag != Tag.ASYNC_JOB_ID) {
            throw new IllegalStateException("Invalid tag: required Tag.ASYNC_JOB_ID, but was Tag." + this._tag.name());
        }
        return this.asyncJobIdValue;
    }

    public boolean isComplete() {
        return this._tag == Tag.COMPLETE;
    }

    public static MembersAddLaunch complete(List<MemberAddResult> value) {
        if (value == null) {
            throw new IllegalArgumentException("Value is null");
        }
        for (MemberAddResult x : value) {
            if (x != null) continue;
            throw new IllegalArgumentException("An item in list is null");
        }
        return new MembersAddLaunch().withTagAndComplete(Tag.COMPLETE, value);
    }

    public List<MemberAddResult> getCompleteValue() {
        if (this._tag != Tag.COMPLETE) {
            throw new IllegalStateException("Invalid tag: required Tag.COMPLETE, but was Tag." + this._tag.name());
        }
        return this.completeValue;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this._tag, this.asyncJobIdValue, this.completeValue});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof MembersAddLaunch) {
            MembersAddLaunch other = (MembersAddLaunch)obj;
            if (this._tag != other._tag) {
                return false;
            }
            switch (this._tag) {
                case ASYNC_JOB_ID: {
                    return this.asyncJobIdValue == other.asyncJobIdValue || this.asyncJobIdValue.equals(other.asyncJobIdValue);
                }
                case COMPLETE: {
                    return this.completeValue == other.completeValue || this.completeValue.equals(other.completeValue);
                }
            }
            return false;
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends UnionSerializer<MembersAddLaunch> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(MembersAddLaunch value, JsonGenerator g2) throws IOException, JsonGenerationException {
            switch (value.tag()) {
                case ASYNC_JOB_ID: {
                    g2.writeStartObject();
                    this.writeTag("async_job_id", g2);
                    g2.writeFieldName("async_job_id");
                    StoneSerializers.string().serialize(value.asyncJobIdValue, g2);
                    g2.writeEndObject();
                    break;
                }
                case COMPLETE: {
                    g2.writeStartObject();
                    this.writeTag("complete", g2);
                    g2.writeFieldName("complete");
                    StoneSerializers.list(MemberAddResult.Serializer.INSTANCE).serialize((List<MemberAddResult>)value.completeValue, g2);
                    g2.writeEndObject();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unrecognized tag: " + (Object)((Object)value.tag()));
                }
            }
        }

        @Override
        public MembersAddLaunch deserialize(JsonParser p) throws IOException, JsonParseException {
            MembersAddLaunch value;
            String tag;
            boolean collapsed;
            if (p.getCurrentToken() == JsonToken.VALUE_STRING) {
                collapsed = true;
                tag = Serializer.getStringValue(p);
                p.nextToken();
            } else {
                collapsed = false;
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                throw new JsonParseException(p, "Required field missing: .tag");
            }
            if ("async_job_id".equals(tag)) {
                String fieldValue = null;
                Serializer.expectField("async_job_id", p);
                fieldValue = StoneSerializers.string().deserialize(p);
                value = MembersAddLaunch.asyncJobId(fieldValue);
            } else if ("complete".equals(tag)) {
                List<MemberAddResult> fieldValue = null;
                Serializer.expectField("complete", p);
                fieldValue = StoneSerializers.list(MemberAddResult.Serializer.INSTANCE).deserialize(p);
                value = MembersAddLaunch.complete(fieldValue);
            } else {
                throw new JsonParseException(p, "Unknown tag: " + tag);
            }
            if (!collapsed) {
                Serializer.skipFields(p);
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static enum Tag {
        ASYNC_JOB_ID,
        COMPLETE;

    }
}

